/// <reference path="./internal_*.d.ts" />
declare namespace Internal {
    class EndGatewayConfiguration implements Internal.FeatureConfiguration {
        getFeatures(): Internal.Stream<Internal.ConfiguredFeature<any, any>>;
        isExitExact(): boolean;
        static knownExit($$0: BlockPos_, $$1: boolean): Internal.EndGatewayConfiguration;
        getExit(): Internal.Optional<BlockPos>;
        static delayedExitSearch(): Internal.EndGatewayConfiguration;
        get features(): Internal.Stream<Internal.ConfiguredFeature<any, any>>
        get exitExact(): boolean
        get exit(): Internal.Optional<BlockPos>
        static readonly CODEC: Internal.Codec<Internal.EndGatewayConfiguration>;
    }
    type EndGatewayConfiguration_ = EndGatewayConfiguration;
    interface ICrankable {
        abstract applyTurn(): void;
        get(level: Internal.Level_, pos: BlockPos_, side: Internal.Direction_): this;
        abstract canTurn(): boolean;
        readonly LOOKUP: Internal.BlockApiLookup<Internal.ICrankable, Internal.Direction>;
    }
    type ICrankable_ = ICrankable;
    interface ConfigParser <C extends dev.lambdaurora.lambdynlights.shadow.nightconfig.core.Config> {
        parse(file: Internal.File_, notFoundAction: Internal.FileNotFoundAction_, charset: Internal.Charset_): C;
        abstract parse(arg0: Internal.Reader_, arg1: dev.lambdaurora.lambdynlights.shadow.nightconfig.core.Config_, arg2: Internal.ParsingMode_): void;
        parse(file: Internal.Path_, notFoundAction: Internal.FileNotFoundAction_): C;
        abstract getFormat(): dev.lambdaurora.lambdynlights.shadow.nightconfig.core.ConfigFormat<C>;
        parse(url: Internal.URL_, destination: dev.lambdaurora.lambdynlights.shadow.nightconfig.core.Config_, parsingMode: Internal.ParsingMode_): void;
        parse(file: Internal.Path_, notFoundAction: Internal.FileNotFoundAction_, charset: Internal.Charset_): C;
        parse(file: Internal.File_, notFoundAction: Internal.FileNotFoundAction_): C;
        parse(file: Internal.Path_, destination: dev.lambdaurora.lambdynlights.shadow.nightconfig.core.Config_, parsingMode: Internal.ParsingMode_, notFoundAction: Internal.FileNotFoundAction_): void;
        parse(file: Internal.Path_, destination: dev.lambdaurora.lambdynlights.shadow.nightconfig.core.Config_, parsingMode: Internal.ParsingMode_, notFoundAction: Internal.FileNotFoundAction_, charset: Internal.Charset_): void;
        parse(input: Internal.InputStream_, destination: dev.lambdaurora.lambdynlights.shadow.nightconfig.core.Config_, parsingMode: Internal.ParsingMode_, charset: Internal.Charset_): void;
        abstract parse(arg0: Internal.Reader_): C;
        parse(url: Internal.URL_): C;
        parse(input: string, destination: dev.lambdaurora.lambdynlights.shadow.nightconfig.core.Config_, parsingMode: Internal.ParsingMode_): void;
        parse(input: string): C;
        parse(input: Internal.InputStream_, charset: Internal.Charset_): C;
        parse(input: Internal.InputStream_): C;
        parse(file: Internal.File_, destination: dev.lambdaurora.lambdynlights.shadow.nightconfig.core.Config_, parsingMode: Internal.ParsingMode_, notFoundAction: Internal.FileNotFoundAction_, charset: Internal.Charset_): void;
        parse(file: Internal.File_, destination: dev.lambdaurora.lambdynlights.shadow.nightconfig.core.Config_, parsingMode: Internal.ParsingMode_, notFoundAction: Internal.FileNotFoundAction_): void;
        parse(input: Internal.InputStream_, destination: dev.lambdaurora.lambdynlights.shadow.nightconfig.core.Config_, parsingMode: Internal.ParsingMode_): void;
        get format(): dev.lambdaurora.lambdynlights.shadow.nightconfig.core.ConfigFormat<C>
    }
    type ConfigParser_<C extends dev.lambdaurora.lambdynlights.shadow.nightconfig.core.Config> = ConfigParser<C>;
    abstract class ComponentKey <C extends dev.onyxstudios.cca.api.v3.component.Component> {
        isProvidedBy(provider: any): boolean;
        sync(provider: any, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        abstract getInternal(arg0: Internal.ComponentContainer_): C;
        get(provider: any): C;
        syncWith(player: Internal.ServerPlayer_, provider: Internal.ComponentProvider_, writer: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        getComponentClass(): C;
        maybeGet(provider: any): Internal.Optional<C>;
        sync(provider: any): void;
        syncWith(player: Internal.ServerPlayer_, provider: Internal.ComponentProvider_): void;
        getFromContainer(container: Internal.ComponentContainer_): C;
        getNullable(provider: any): C;
        getId(): ResourceLocation;
        sync(provider: any, packetWriter: Internal.ComponentPacketWriter_): void;
        get componentClass(): C
        get id(): ResourceLocation
    }
    type ComponentKey_<C extends dev.onyxstudios.cca.api.v3.component.Component> = ComponentKey<C>;
    class DropTargetEvent extends Internal.EventObject {
        constructor(arg0: Internal.DropTargetContext_)
        getDropTargetContext(): Internal.DropTargetContext;
        get dropTargetContext(): Internal.DropTargetContext
    }
    type DropTargetEvent_ = DropTargetEvent;
    interface Collector <T, A, R> {
        abstract accumulator(): Internal.BiConsumer<A, T>;
        of<T, A, R>(arg0: Internal.Supplier_<A>, arg1: Internal.BiConsumer_<A, T>, arg2: Internal.BinaryOperator_<A>, arg3: Internal.Function_<A, R>, ...arg4: Internal.Collector$Characteristics_[]): this;
        abstract characteristics(): Internal.Set<Internal.Collector$Characteristics>;
        abstract supplier(): Internal.Supplier<A>;
        abstract finisher(): Internal.Function<A, R>;
        abstract combiner(): Internal.BinaryOperator<A>;
        of<T, R>(arg0: Internal.Supplier_<R>, arg1: Internal.BiConsumer_<R, T>, arg2: Internal.BinaryOperator_<R>, ...arg3: Internal.Collector$Characteristics_[]): Internal.Collector<T, R, R>;
    }
    type Collector_<T, A, R> = Collector<T, A, R>;
    abstract class Contraption implements Internal.IContraptionFuel {
        constructor()
        getSimplifiedEntityColliders(): Internal.Optional<Internal.List<Internal.AABB>>;
        getSeatMapping(): Internal.Map<Internal.UUID, number>;
        getBlockEntityClientSide(localPos: BlockPos_): Internal.BlockEntity;
        getBlocks(): Internal.Map<BlockPos, Internal.StructureTemplate$StructureBlockInfo>;
        onEntityCreated(entity: Internal.AbstractContraptionEntity_): void;
        setSeatMapping(seatMapping: Internal.Map_<Internal.UUID, number>): void;
        getSeats(): Internal.List<BlockPos>;
        writeStorage(nbt: Internal.CompoundTag_, spawnPacket: boolean): void;
        getOrCreateClientContraptionLazy(): Internal.ClientContraption;
        invalidateClientContraptionChildren(): void;
        getDisabledActors(): Internal.List<Internal.ItemStack>;
        abstract assemble(arg0: Internal.Level_, arg1: BlockPos_): boolean;
        getContraptionWorld(): Internal.ContraptionWorld;
        containsBlockBreakers(): boolean;
        forEachActor(world: Internal.Level_, callBack: Internal.BiConsumer_<Internal.MovementBehaviour, Internal.MovementContext>): void;
        expandBoundsAroundAxis(axis: Internal.Direction$Axis_): void;
        searchMovedStructure(world: Internal.Level_, pos: BlockPos_, forcedDirection: Internal.Direction_): boolean;
        getInteractors(): Internal.Map<BlockPos, Internal.MovingInteractionBehaviour>;
        isActorTypeDisabled(filter: Internal.ItemStack_): boolean;
        static getRadius(blocks: Internal.Iterable_<Vec3i>, axis: Internal.Direction$Axis_): number;
        writeNBT(spawnPacket: boolean): Internal.CompoundTag;
        getIsLegacy(): Internal.Object2BooleanMap<BlockPos>;
        getSeatOf(entityId: Internal.UUID_): BlockPos;
        invalidateColliders(): void;
        setActorsActive(referenceStack: Internal.ItemStack_, enable: boolean): void;
        onEntityInitialize(world: Internal.Level_, contraptionEntity: Internal.AbstractContraptionEntity_): void;
        getActorAt(localPos: BlockPos_): Internal.MutablePair<Internal.StructureTemplate$StructureBlockInfo, Internal.MovementContext>;
        stop(world: Internal.Level_): void;
        addPassengersToWorld(world: Internal.Level_, transform: Internal.StructureTransform_, seatedEntities: Internal.List_<Internal.Entity>): void;
        getBearingPosOf(subContraptionEntityId: Internal.UUID_): BlockPos;
        getStorage(): Internal.MountedStorageManager;
        readNBT(world: Internal.Level_, nbt: Internal.CompoundTag_, spawnData: boolean): void;
        startMoving(world: Internal.Level_): void;
        abstract getType(): Internal.ContraptionType;
        isHiddenInPortal(localPos: BlockPos_): boolean;
        tickStorage(entity: Internal.AbstractContraptionEntity_): void;
        resetClientContraption(): void;
        removeBlocksFromWorld(world: Internal.Level_, offset: BlockPos_): void;
        railways$getFluidFuels(): Internal.MountedFluidStorageWrapper;
        abstract canBeStabilized(arg0: Internal.Direction_, arg1: BlockPos_): boolean;
        addBlocksToWorld(world: Internal.Level_, transform: Internal.StructureTransform_): void;
        invalidateClientContraptionStructure(): void;
        getActors(): Internal.List<Internal.MutablePair<Internal.StructureTemplate$StructureBlockInfo, Internal.MovementContext>>;
        onEntityRemoved(entity: Internal.AbstractContraptionEntity_): void;
        static fromNBT(world: Internal.Level_, nbt: Internal.CompoundTag_, spawnData: boolean): Internal.Contraption;
        get simplifiedEntityColliders(): Internal.Optional<Internal.List<Internal.AABB>>
        get seatMapping(): Internal.Map<Internal.UUID, number>
        get blocks(): Internal.Map<BlockPos, Internal.StructureTemplate$StructureBlockInfo>
        set seatMapping(seatMapping: Internal.Map_<Internal.UUID, number>)
        get seats(): Internal.List<BlockPos>
        get orCreateClientContraptionLazy(): Internal.ClientContraption
        get disabledActors(): Internal.List<Internal.ItemStack>
        get contraptionWorld(): Internal.ContraptionWorld
        get interactors(): Internal.Map<BlockPos, Internal.MovingInteractionBehaviour>
        get isLegacy(): Internal.Object2BooleanMap<BlockPos>
        get storage(): Internal.MountedStorageManager
        get type(): Internal.ContraptionType
        get actors(): Internal.List<Internal.MutablePair<Internal.StructureTemplate$StructureBlockInfo, Internal.MovementContext>>
        simplifiedEntityColliders: Internal.Optional<Internal.List<Internal.AABB>>;
        hasUniversalCreativeCrate: boolean;
        bounds: Internal.AABB;
        anchor: BlockPos;
        stalled: boolean;
        entity: Internal.AbstractContraptionEntity;
        disassembled: boolean;
        isLegacy: Internal.Object2BooleanMap<BlockPos>;
    }
    type Contraption_ = Contraption;
    class CrossbowItem extends Internal.ProjectileWeaponItem implements Internal.Vanishable {
        constructor($$0: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        static isCharged($$0: Internal.ItemStack_): boolean;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        static getChargeDuration($$0: Internal.ItemStack_): number;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        static performShooting($$0: Internal.Level_, $$1: Internal.LivingEntity_, $$2: Internal.InteractionHand_, $$3: Internal.ItemStack_, $$4: number, $$5: number): void;
        setArmorToughness(armorToughness: number): void;
        static setCharged($$0: Internal.ItemStack_, $$1: boolean): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        static containsChargedProjectile($$0: Internal.ItemStack_, $$1: Internal.Item_): boolean;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        static readonly DEFAULT_RANGE: 8;
    }
    type CrossbowItem_ = CrossbowItem;
    class MoltenBismuthFluid extends Internal.MoltenMetalFluid {
        constructor(properties: Internal.ModFlowingFluid$Properties_, block: Internal.Supplier_<Internal.LiquidBlock>)
        arch$holder(): Internal.Holder<Internal.Fluid>;
        arch$registryName(): ResourceLocation;
    }
    type MoltenBismuthFluid_ = MoltenBismuthFluid;
    class IceSpikeFeature extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor($$0: Internal.Codec_<Internal.NoneFeatureConfiguration>)
    }
    type IceSpikeFeature_ = IceSpikeFeature;
    class InteractionResult extends Internal.Enum<Internal.InteractionResult> {
        static values(): Internal.InteractionResult[];
        shouldSwing(): boolean;
        static sidedSuccess($$0: boolean): Internal.InteractionResult;
        shouldAwardStats(): boolean;
        consumesAction(): boolean;
        static valueOf($$0: string): Internal.InteractionResult;
        static readonly PASS: Internal.InteractionResult;
        static readonly CONSUME_PARTIAL: Internal.InteractionResult;
        static readonly FAIL: Internal.InteractionResult;
        static readonly CONSUME: Internal.InteractionResult;
        static readonly SUCCESS: Internal.InteractionResult;
    }
    type InteractionResult_ = InteractionResult | "pass" | "consume" | "success" | "consume_partial" | "fail";
    class DragonSittingScanningPhase extends Internal.AbstractDragonSittingPhase {
        constructor($$0: Internal.EnderDragon_)
        getPhase(): Internal.EnderDragonPhase<Internal.DragonSittingScanningPhase>;
        get phase(): Internal.EnderDragonPhase<Internal.DragonSittingScanningPhase>
    }
    type DragonSittingScanningPhase_ = DragonSittingScanningPhase;
    interface TierExtensions {
        getTag(): Internal.TagKey<Internal.Block>;
        get tag(): Internal.TagKey<Internal.Block>
    }
    type TierExtensions_ = TierExtensions;
    abstract class AbstractIllager extends Internal.Raider {
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        isTouchingUpsideDownFluid(): boolean;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        swing(): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        getCustomData(): Internal.CompoundTag;
        damageHeldItem(): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        attack(hp: number): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        captureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        getArmPose(): Internal.AbstractIllager$IllagerArmPose;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        getType(): string;
        self(): Internal.Entity;
        setChestArmorItem(item: Internal.ItemStack_): void;
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnEquipmentChanged(): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        changeDimension(p_20118_: Internal.ServerLevel_, teleporter: Internal.ITeleporter_): Internal.Entity;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        set defaultMovementSpeedMultiplier(speed: number)
        get touchingUpsideDownFluid(): boolean
        get offHandItem(): Internal.ItemStack
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get customData(): Internal.CompoundTag
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get armPose(): Internal.AbstractIllager$IllagerArmPose
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get touchingFluid(): Internal.FluidState
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
    }
    type AbstractIllager_ = AbstractIllager;
    class ByteOrder {
        static nativeOrder(): Internal.ByteOrder;
        static readonly BIG_ENDIAN: Internal.ByteOrder;
        static readonly LITTLE_ENDIAN: Internal.ByteOrder;
    }
    type ByteOrder_ = ByteOrder;
    class ForgeConfigSpec$ValueSpec {
        test(value: any): boolean;
        getRange<V extends Internal.Comparable<any>>(): Internal.ForgeConfigSpec$Range<V>;
        getComment(): string;
        getDefault(): any;
        getClazz(): typeof any;
        getTranslationKey(): string;
        needsWorldRestart(): boolean;
        correct(value: any): any;
        get range(): Internal.ForgeConfigSpec$Range<V>
        get comment(): string
        get "default"(): any
        get clazz(): typeof any
        get translationKey(): string
    }
    type ForgeConfigSpec$ValueSpec_ = ForgeConfigSpec$ValueSpec;
    class StructurePiecesBuilder implements Internal.StructurePieceAccessor {
        constructor()
        addPiece($$0: Internal.StructurePiece_): void;
        clear(): void;
        /**
         * @deprecated
        */
        offsetPiecesVertically($$0: number): void;
        build(): Internal.PiecesContainer;
        findCollisionPiece($$0: Internal.BoundingBox_): Internal.StructurePiece;
        isEmpty(): boolean;
        /**
         * @deprecated
        */
        moveBelowSeaLevel($$0: number, $$1: number, $$2: Internal.RandomSource_, $$3: number): number;
        moveInsideHeights($$0: Internal.RandomSource_, $$1: number, $$2: number): void;
        getBoundingBox(): Internal.BoundingBox;
        get empty(): boolean
        get boundingBox(): Internal.BoundingBox
    }
    type StructurePiecesBuilder_ = StructurePiecesBuilder;
    interface Long2ByteFunction extends Internal.LongToIntFunction, it.unimi.dsi.fastutil.Function<number, number> {
        andThenLong(arg0: Internal.Byte2LongFunction_): Internal.Long2LongFunction;
        /**
         * @deprecated
        */
        put(arg0: number, arg1: number): number;
        composeShort(arg0: Internal.Short2LongFunction_): Internal.Short2ByteFunction;
        andThenFloat(arg0: Internal.Byte2FloatFunction_): Internal.Long2FloatFunction;
        andThenReference<T>(arg0: Internal.Byte2ReferenceFunction_<T>): Internal.Long2ReferenceFunction<T>;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        getOrDefault(arg0: number, arg1: number): number;
        andThenByte(arg0: Internal.Byte2ByteFunction_): this;
        composeDouble(arg0: Internal.Double2LongFunction_): Internal.Double2ByteFunction;
        composeInt(arg0: Internal.Int2LongFunction_): Internal.Int2ByteFunction;
        abstract get(arg0: number): number;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<number, T>;
        remove(arg0: number): number;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, number>;
        andThenShort(arg0: Internal.Byte2ShortFunction_): Internal.Long2ShortFunction;
        defaultReturnValue(arg0: number): void;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        applyAsInt(arg0: number): number;
        composeReference<T>(arg0: Internal.Reference2LongFunction_<T>): Internal.Reference2ByteFunction<T>;
        defaultReturnValue(): number;
        composeFloat(arg0: Internal.Float2LongFunction_): Internal.Float2ByteFunction;
        composeLong(arg0: Internal.Long2LongFunction_): this;
        composeObject<T>(arg0: Internal.Object2LongFunction_<T>): Internal.Object2ByteFunction<T>;
        composeChar(arg0: Internal.Char2LongFunction_): Internal.Char2ByteFunction;
        put(arg0: number, arg1: number): number;
        apply(arg0: number): number;
        containsKey(arg0: number): boolean;
        andThenObject<T>(arg0: Internal.Byte2ObjectFunction_<T>): Internal.Long2ObjectFunction<T>;
        composeByte(arg0: Internal.Byte2LongFunction_): Internal.Byte2ByteFunction;
        andThenChar(arg0: Internal.Byte2CharFunction_): Internal.Long2CharFunction;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: number): number;
        size(): number;
        andThenDouble(arg0: Internal.Byte2DoubleFunction_): Internal.Long2DoubleFunction;
        clear(): void;
        /**
         * @deprecated
        */
        remove(arg0: any): any;
        /**
         * @deprecated
        */
        get(arg0: any): any;
        identity<T>(): Internal.Function<T, T>;
        andThenInt(arg0: Internal.Byte2IntFunction_): Internal.Long2IntFunction;
        (arg0: number): number;
    }
    type Long2ByteFunction_ = Long2ByteFunction;
    class EnergyCardItem extends Internal.UpgradeCardItem {
        constructor(properties: Internal.Item$Properties_, energyMultiplier: number)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        getEnergyMultiplier(): number;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        emi(): Internal.EmiStack;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        get energyMultiplier(): number
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type EnergyCardItem_ = EnergyCardItem;
    abstract class EffectRenderingInventoryScreen <T extends Internal.AbstractContainerMenu> extends Internal.AbstractContainerScreen<T> {
        constructor($$0: T, $$1: Internal.Inventory_, $$2: net.minecraft.network.chat.Component_)
        charTyped($$0: string, $$1: number): boolean;
        isFocused(): boolean;
        magicalSpecialHackyFocus($$0: Internal.GuiEventListener_): void;
        redirect$hma000$yet_another_config_lib_v3$modifyFocusCandidates(instance: Internal.ContainerEventHandler_, screenArea: Internal.ScreenRectangle_, direction: Internal.ScreenDirection_, focused: Internal.GuiEventListener_, event: Internal.FocusNavigationEvent_): Internal.List<any>;
        canSeeEffects(): boolean;
        setFocused($$0: boolean): void;
        adastra$renderPreSlot(graphics: Internal.GuiGraphics_, slot: Internal.Slot_): void;
        sophisticatedcore_getSlotColor(slotId: number): number;
        getTabOrderGroup(): number;
        mouseScrolled($$0: number, $$1: number, $$2: number): boolean;
        keyReleased($$0: number, $$1: number, $$2: number): boolean;
        getCurrentFocusPath(): Internal.ComponentPath;
        static getExtensions(screen: Internal.Screen_): Internal.ScreenExtensions;
        getChildAt($$0: number, $$1: number): Internal.Optional<Internal.GuiEventListener>;
        mouseMoved($$0: number, $$1: number): void;
        nextFocusPath($$0: Internal.FocusNavigationEvent_): Internal.ComponentPath;
        get focused(): boolean
        set focused($$0: boolean)
        get tabOrderGroup(): number
        get currentFocusPath(): Internal.ComponentPath
    }
    type EffectRenderingInventoryScreen_<T extends Internal.AbstractContainerMenu> = EffectRenderingInventoryScreen<T>;
    interface BuiltInExceptionProvider {
        abstract dispatcherParseException(): Internal.DynamicCommandExceptionType;
        abstract readerExpectedInt(): Internal.SimpleCommandExceptionType;
        abstract floatTooLow(): Internal.Dynamic2CommandExceptionType;
        abstract readerInvalidBool(): Internal.DynamicCommandExceptionType;
        abstract readerInvalidEscape(): Internal.DynamicCommandExceptionType;
        abstract readerInvalidLong(): Internal.DynamicCommandExceptionType;
        abstract readerInvalidDouble(): Internal.DynamicCommandExceptionType;
        abstract readerInvalidInt(): Internal.DynamicCommandExceptionType;
        abstract integerTooLow(): Internal.Dynamic2CommandExceptionType;
        abstract longTooLow(): Internal.Dynamic2CommandExceptionType;
        abstract floatTooHigh(): Internal.Dynamic2CommandExceptionType;
        abstract readerExpectedLong(): Internal.SimpleCommandExceptionType;
        abstract dispatcherUnknownCommand(): Internal.SimpleCommandExceptionType;
        abstract integerTooHigh(): Internal.Dynamic2CommandExceptionType;
        abstract readerExpectedFloat(): Internal.SimpleCommandExceptionType;
        abstract longTooHigh(): Internal.Dynamic2CommandExceptionType;
        abstract readerExpectedSymbol(): Internal.DynamicCommandExceptionType;
        abstract readerExpectedEndOfQuote(): Internal.SimpleCommandExceptionType;
        abstract doubleTooHigh(): Internal.Dynamic2CommandExceptionType;
        abstract doubleTooLow(): Internal.Dynamic2CommandExceptionType;
        abstract readerExpectedStartOfQuote(): Internal.SimpleCommandExceptionType;
        abstract dispatcherUnknownArgument(): Internal.SimpleCommandExceptionType;
        abstract readerExpectedBool(): Internal.SimpleCommandExceptionType;
        abstract literalIncorrect(): Internal.DynamicCommandExceptionType;
        abstract readerInvalidFloat(): Internal.DynamicCommandExceptionType;
        abstract readerExpectedDouble(): Internal.SimpleCommandExceptionType;
        abstract dispatcherExpectedArgumentSeparator(): Internal.SimpleCommandExceptionType;
    }
    type BuiltInExceptionProvider_ = BuiltInExceptionProvider;
    class AnimatableProperty <A extends Internal.Animatable<A>> extends Internal.Observable<A> {
        update(delta: number): void;
        static of<A extends Internal.Animatable<A>>(initial: A): Internal.AnimatableProperty<A>;
        animation(): Internal.Animation<A>;
        animate(duration: number, easing: Internal.Easing_, to: A): Internal.Animation<A>;
    }
    type AnimatableProperty_<A extends Internal.Animatable<A>> = AnimatableProperty<A>;
    abstract class ThrowableProjectile extends Internal.Projectile {
        setMotionY(y: number): void;
        isPeacefulCreature(): boolean;
        getDistance(pos: BlockPos_): number;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        setRotation(yaw: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        isOnScoreboardTeam(teamId: string): boolean;
        getType(): string;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        self(): Internal.Entity;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        setPosition(x: number, y: number, z: number): void;
        getPassengers(): Internal.EntityArrayList;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnBlockCacheSet(newState: Internal.BlockState_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        isLiving(): boolean;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        alwaysAccepts(): boolean;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        getDisplayName(): net.minecraft.network.chat.Component;
        setMotionX(x: number): void;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        attack(hp: number): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getTeamId(): string;
        setNbt(nbt: Internal.CompoundTag_): void;
        lithiumSetClimbingMobCachingSectionUpdateBehavior(listening: boolean): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        serializeNBT(): Internal.Tag;
        setDynamicLightEnabled(enabled: boolean): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        tell(message: net.minecraft.network.chat.Component_): void;
        handler$zip000$ad_astra$adastra$getGravity(cir: Internal.CallbackInfoReturnable_<any>): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        isFrame(): boolean;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        getProfile(): Internal.GameProfile;
        playSound(id: Internal.SoundEvent_): void;
        lithiumOnBlockCacheDeleted(): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        runCommand(command: string): number;
        getDistance(x: number, y: number, z: number): number;
        set motionY(y: number)
        get peacefulCreature(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get server(): Internal.MinecraftServer
        get displayName(): net.minecraft.network.chat.Component
        set motionX(x: number)
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        get facing(): Internal.Direction
        set dynamicLightEnabled(enabled: boolean)
        get motionX(): number
        get waterCreature(): boolean
        get motionZ(): number
        get item(): Internal.ItemStack
        set x(x: number)
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get frame(): boolean
        get profile(): Internal.GameProfile
    }
    type ThrowableProjectile_ = ThrowableProjectile;
    class Redstone extends Internal.Enum<Internal.Redstone> {
        static valueOf(name: string): Internal.Redstone;
        getDisplayName(): net.minecraft.network.chat.Component;
        static values(): Internal.Redstone[];
        next(): this;
        get displayName(): net.minecraft.network.chat.Component
        static readonly ON: Internal.Redstone;
        static readonly OFF: Internal.Redstone;
        static readonly IGNORE: Internal.Redstone;
    }
    type Redstone_ = "on" | Redstone | "ignore" | "off";
    class PendingInvitesList extends Internal.ValueObject {
        constructor()
        static parse($$0: string): Internal.PendingInvitesList;
        pendingInvites: Internal.List<Internal.PendingInvite>;
    }
    type PendingInvitesList_ = PendingInvitesList;
    class MultifaceSpreader$SpreadPos extends Internal.Record {
        constructor($$0: BlockPos_, $$1: Internal.Direction_)
        face(): Internal.Direction;
        pos(): BlockPos;
    }
    type MultifaceSpreader$SpreadPos_ = MultifaceSpreader$SpreadPos;
    class ProtoChunk extends Internal.ChunkAccess implements Internal.ExtendedChunk {
        constructor($$0: Internal.ChunkPos_, $$1: Internal.UpgradeData_, $$2: Internal.LevelChunkSection_[], $$3: Internal.ProtoChunkTicks_<Internal.Block>, $$4: Internal.ProtoChunkTicks_<Internal.Fluid>, $$5: Internal.LevelHeightAccessor_, $$6: Internal.Registry_<Internal.Biome>, $$7: Internal.BlendingData_)
        constructor($$0: Internal.ChunkPos_, $$1: Internal.UpgradeData_, $$2: Internal.LevelHeightAccessor_, $$3: Internal.Registry_<Internal.Biome>, $$4: Internal.BlendingData_)
        syncComponent(key: Internal.ComponentKey_<any>): void;
        getMinSection(): number;
        setStatus($$0: Internal.ChunkStatus_): void;
        clipWithInteractionOverride($$0: Vec3d_, $$1: Vec3d_, $$2: BlockPos_, $$3: Internal.VoxelShape_, $$4: Internal.BlockState_): Internal.BlockHitResult;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getMaxSection(): number;
        unpackFluidTicks(): Internal.LevelChunkTicks<Internal.Fluid>;
        getBiomeFabric(pos: BlockPos_): Internal.Holder<Internal.Biome>;
        getLightEmission($$0: BlockPos_): number;
        getBlockFloorHeight($$0: BlockPos_): number;
        getSectionYFromSectionIndex($$0: number): number;
        static create($$0: number, $$1: number): Internal.LevelHeightAccessor;
        clip($$0: Internal.ClipContext_): Internal.BlockHitResult;
        setLightEngine($$0: Internal.LevelLightEngine_): void;
        setCarvingMask($$0: Internal.GenerationStep$Carving_, $$1: Internal.CarvingMask_): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        static unpackOffsetCoordinates($$0: number, $$1: number, $$2: Internal.ChunkPos_): BlockPos;
        getBlockEntity<T extends Internal.BlockEntity>($$0: BlockPos_, $$1: Internal.BlockEntityType_<T>): Internal.Optional<T>;
        isOutsideBuildHeight($$0: BlockPos_): boolean;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        handler$hip000$starlight$onConstruct(chunkPos: Internal.ChunkPos_, upgradeData: Internal.UpgradeData_, levelChunkSections: Internal.LevelChunkSection_[], protoChunkTicks: Internal.ProtoChunkTicks_<any>, protoChunkTicks2: Internal.ProtoChunkTicks_<any>, levelHeightAccessor: Internal.LevelHeightAccessor_, registry: Internal.Registry_<any>, blendingData: Internal.BlendingData_, ci: Internal.CallbackInfo_): void;
        asComponentProvider(): Internal.ComponentProvider;
        getRecipientsForComponentSync(): Internal.Iterable<Internal.ServerPlayer>;
        getBlockStates($$0: Internal.AABB_): Internal.Stream<Internal.BlockState>;
        setBelowZeroRetrogen($$0: Internal.BelowZeroRetrogen_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        addEntity($$0: Internal.CompoundTag_): void;
        static packOffsetCoordinates($$0: BlockPos_): number;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getSectionsCount(): number;
        getBlockEntityNbts(): Internal.Map<BlockPos, Internal.CompoundTag>;
        getSectionIndexFromSectionY($$0: number): number;
        getCarvingMask($$0: Internal.GenerationStep$Carving_): Internal.CarvingMask;
        getEntities(): Internal.List<Internal.CompoundTag>;
        getSectionIndex($$0: number): number;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        toComponentPacket<C extends Internal.AutoSyncedComponent>(key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        getMaxBuildHeight(): number;
        getBlockEntityRenderData(pos: BlockPos_): any;
        getOrCreateCarvingMask($$0: Internal.GenerationStep$Carving_): Internal.CarvingMask;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        unpackBlockTicks(): Internal.LevelChunkTicks<Internal.Block>;
        getBlockFloorHeight($$0: Internal.VoxelShape_, $$1: Internal.Supplier_<Internal.VoxelShape>): number;
        isOutsideBuildHeight($$0: number): boolean;
        isBlockInLine($$0: Internal.ClipBlockStateContext_): Internal.BlockHitResult;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        hasBiomes(): boolean;
        getBlockEntities(): Internal.Map<BlockPos, Internal.BlockEntity>;
        getMaxLightLevel(): number;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        static traverseBlocks<T, C>($$0: Vec3d_, $$1: Vec3d_, $$2: C, $$3: Internal.BiFunction_<C, BlockPos, T>, $$4: Internal.Function_<C, T>): T;
        get minSection(): number
        set status($$0: Internal.ChunkStatus_)
        get maxSection(): number
        set lightEngine($$0: Internal.LevelLightEngine_)
        get recipientsForComponentSync(): Internal.Iterable<Internal.ServerPlayer>
        set belowZeroRetrogen($$0: Internal.BelowZeroRetrogen_)
        get sectionsCount(): number
        get blockEntityNbts(): Internal.Map<BlockPos, Internal.CompoundTag>
        get entities(): Internal.List<Internal.CompoundTag>
        get maxBuildHeight(): number
        get blockEntities(): Internal.Map<BlockPos, Internal.BlockEntity>
        get maxLightLevel(): number
    }
    type ProtoChunk_ = ProtoChunk;
    class VariantBlockStateBuilder implements Internal.IGeneratedBlockState {
        getOwner(): Internal.Block;
        forAllStatesExcept(mapper: Internal.Function_<Internal.BlockState, Internal.ConfiguredModel[]>, ...ignored: Internal.Property_<any>[]): this;
        forAllStates(mapper: Internal.Function_<Internal.BlockState, Internal.ConfiguredModel[]>): this;
        getModels(): Internal.Map<Internal.VariantBlockStateBuilder$PartialBlockstate, Internal.BlockStateProvider$ConfiguredModelList>;
        setModels(state: Internal.VariantBlockStateBuilder$PartialBlockstate_, ...model: Internal.ConfiguredModel_[]): this;
        partialState(): Internal.VariantBlockStateBuilder$PartialBlockstate;
        addModels(state: Internal.VariantBlockStateBuilder$PartialBlockstate_, ...models: Internal.ConfiguredModel_[]): this;
        toJson(): Internal.JsonObject;
        get owner(): Internal.Block
        get models(): Internal.Map<Internal.VariantBlockStateBuilder$PartialBlockstate, Internal.BlockStateProvider$ConfiguredModelList>
    }
    type VariantBlockStateBuilder_ = VariantBlockStateBuilder;
    class PartDefinition {
        bake($$0: number, $$1: number): Internal.ModelPart;
        getChild($$0: string): this;
        addOrReplaceChild($$0: string, $$1: Internal.CubeListBuilder_, $$2: Internal.PartPose_): this;
    }
    type PartDefinition_ = PartDefinition;
    class GeodeBlockSettings {
        constructor($$0: Internal.BlockStateProvider_, $$1: Internal.BlockStateProvider_, $$2: Internal.BlockStateProvider_, $$3: Internal.BlockStateProvider_, $$4: Internal.BlockStateProvider_, $$5: Internal.List_<Internal.BlockState>, $$6: Internal.TagKey_<Internal.Block>, $$7: Internal.TagKey_<Internal.Block>)
        readonly innerLayerProvider: Internal.BlockStateProvider;
        readonly middleLayerProvider: Internal.BlockStateProvider;
        readonly fillingProvider: Internal.BlockStateProvider;
        readonly alternateInnerLayerProvider: Internal.BlockStateProvider;
        readonly outerLayerProvider: Internal.BlockStateProvider;
        readonly invalidBlocks: Internal.TagKey<Internal.Block>;
        static readonly CODEC: Internal.Codec<Internal.GeodeBlockSettings>;
        readonly innerPlacements: Internal.List<Internal.BlockState>;
        readonly cannotReplace: Internal.TagKey<Internal.Block>;
    }
    type GeodeBlockSettings_ = GeodeBlockSettings;
    class RegistrateItemTagsProvider extends Internal.RegistrateTagsProvider$IntrinsicImpl<Internal.Item> {
        constructor(owner: Internal.AbstractRegistrate_<any>, type: Internal.ProviderType_<Internal.RegistrateItemTagsProvider>, name: string, output: Internal.FabricDataOutput_, registriesLookup: Internal.CompletableFuture_<Internal.HolderLookup$Provider>, blockTags: Internal.CompletableFuture_<Internal.TagsProvider$TagLookup<Internal.Block>>, existingFileHelper: Internal.ExistingFileHelper_)
        copy(p_206422_: Internal.TagKey_<Internal.Block>, p_206423_: Internal.TagKey_<Internal.Item>): void;
        static saveStable($$0: Internal.CachedOutput_, $$1: Internal.JsonElement_, $$2: Internal.Path_): Internal.CompletableFuture<any>;
    }
    type RegistrateItemTagsProvider_ = RegistrateItemTagsProvider;
    interface Object2DoubleFunction <K> extends it.unimi.dsi.fastutil.Function<K, number>, Internal.ToDoubleFunction<K> {
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<K, T>;
        put(arg0: K, arg1: number): number;
        andThenLong(arg0: Internal.Double2LongFunction_): Internal.Object2LongFunction<K>;
        andThenReference<T>(arg0: Internal.Double2ReferenceFunction_<T>): Internal.Object2ReferenceFunction<K, T>;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        /**
         * @deprecated
        */
        get(arg0: any): number;
        composeShort(arg0: Internal.Short2ObjectFunction_<K>): Internal.Short2DoubleFunction;
        andThenByte(arg0: Internal.Double2ByteFunction_): Internal.Object2ByteFunction<K>;
        containsKey(arg0: any): boolean;
        andThenFloat(arg0: Internal.Double2FloatFunction_): Internal.Object2FloatFunction<K>;
        composeReference<T>(arg0: Internal.Reference2ObjectFunction_<T, K>): Internal.Reference2DoubleFunction<T>;
        andThenDouble(arg0: Internal.Double2DoubleFunction_): this;
        composeObject<T>(arg0: Internal.Object2ObjectFunction_<T, K>): Internal.Object2DoubleFunction<T>;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        defaultReturnValue(arg0: number): void;
        applyAsDouble(arg0: K): number;
        composeFloat(arg0: Internal.Float2ObjectFunction_<K>): Internal.Float2DoubleFunction;
        /**
         * @deprecated
        */
        remove(arg0: any): number;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: number): number;
        composeInt(arg0: Internal.Int2ObjectFunction_<K>): Internal.Int2DoubleFunction;
        composeChar(arg0: Internal.Char2ObjectFunction_<K>): Internal.Char2DoubleFunction;
        composeDouble(arg0: Internal.Double2ObjectFunction_<K>): Internal.Double2DoubleFunction;
        removeDouble(arg0: any): number;
        andThenShort(arg0: Internal.Double2ShortFunction_): Internal.Object2ShortFunction<K>;
        defaultReturnValue(): number;
        apply(arg0: K): number;
        andThenObject<T>(arg0: Internal.Double2ObjectFunction_<T>): Internal.Object2ObjectFunction<K, T>;
        size(): number;
        composeByte(arg0: Internal.Byte2ObjectFunction_<K>): Internal.Byte2DoubleFunction;
        composeLong(arg0: Internal.Long2ObjectFunction_<K>): Internal.Long2DoubleFunction;
        andThenChar(arg0: Internal.Double2CharFunction_): Internal.Object2CharFunction<K>;
        clear(): void;
        getOrDefault(arg0: any, arg1: number): number;
        /**
         * @deprecated
        */
        put(arg0: K, arg1: number): number;
        abstract getDouble(arg0: any): number;
        andThenInt(arg0: Internal.Double2IntFunction_): Internal.Object2IntFunction<K>;
        identity<T>(): Internal.Function<T, T>;
        compose<V>(arg0: Internal.Function_<V, K>): Internal.Function<V, number>;
        (arg0: any): number;
    }
    type Object2DoubleFunction_<K> = Object2DoubleFunction<K>;
    interface LithiumCooldownReceivingInventory {
        setTransferCooldown(currentTime: number): void;
        canReceiveTransferCooldown(): boolean;
        set transferCooldown(currentTime: number)
    }
    type LithiumCooldownReceivingInventory_ = LithiumCooldownReceivingInventory;
    class EntityArgument implements Internal.ArgumentType<Internal.EntitySelector> {
        static getOptionalPlayers($$0: Internal.CommandContext_<Internal.CommandSourceStack>, $$1: string): Internal.Collection<Internal.ServerPlayer>;
        static getPlayer($$0: Internal.CommandContext_<Internal.CommandSourceStack>, $$1: string): Internal.ServerPlayer;
        parse($$0: Internal.StringReader_): Internal.EntitySelector;
        static getEntities($$0: Internal.CommandContext_<Internal.CommandSourceStack>, $$1: string): Internal.Collection<Internal.Entity>;
        listSuggestions<S>($$0: Internal.CommandContext_<S>, $$1: Internal.SuggestionsBuilder_): Internal.CompletableFuture<Internal.Suggestions>;
        static player(): Internal.EntityArgument;
        static getPlayers($$0: Internal.CommandContext_<Internal.CommandSourceStack>, $$1: string): Internal.Collection<Internal.ServerPlayer>;
        static getOptionalEntities($$0: Internal.CommandContext_<Internal.CommandSourceStack>, $$1: string): Internal.Collection<Internal.Entity>;
        getExamples(): Internal.Collection<string>;
        static players(): Internal.EntityArgument;
        static entities(): Internal.EntityArgument;
        parse(arg0: Internal.StringReader_): any;
        static entity(): Internal.EntityArgument;
        static getEntity($$0: Internal.CommandContext_<Internal.CommandSourceStack>, $$1: string): Internal.Entity;
        get examples(): Internal.Collection<string>
        static readonly ERROR_NOT_SINGLE_ENTITY: Internal.SimpleCommandExceptionType;
        static readonly ERROR_NOT_SINGLE_PLAYER: Internal.SimpleCommandExceptionType;
        static readonly ERROR_SELECTORS_NOT_ALLOWED: Internal.SimpleCommandExceptionType;
        static readonly NO_PLAYERS_FOUND: Internal.SimpleCommandExceptionType;
        static readonly ERROR_ONLY_PLAYERS_ALLOWED: Internal.SimpleCommandExceptionType;
        static readonly NO_ENTITIES_FOUND: Internal.SimpleCommandExceptionType;
    }
    type EntityArgument_ = EntityArgument;
    class ClassFileFormatVersion extends Internal.Enum<Internal.ClassFileFormatVersion> {
        static valueOf(arg0: string): Internal.ClassFileFormatVersion;
        static latest(): Internal.ClassFileFormatVersion;
        static fromMajor(arg0: number): Internal.ClassFileFormatVersion;
        static valueOf(arg0: Internal.Runtime$Version_): Internal.ClassFileFormatVersion;
        static values(): Internal.ClassFileFormatVersion[];
        major(): number;
        runtimeVersion(): Internal.Runtime$Version;
        static readonly RELEASE_9: Internal.ClassFileFormatVersion;
        static readonly RELEASE_19: Internal.ClassFileFormatVersion;
        static readonly RELEASE_18: Internal.ClassFileFormatVersion;
        static readonly RELEASE_7: Internal.ClassFileFormatVersion;
        static readonly RELEASE_8: Internal.ClassFileFormatVersion;
        static readonly RELEASE_5: Internal.ClassFileFormatVersion;
        static readonly RELEASE_15: Internal.ClassFileFormatVersion;
        static readonly RELEASE_6: Internal.ClassFileFormatVersion;
        static readonly RELEASE_14: Internal.ClassFileFormatVersion;
        static readonly RELEASE_3: Internal.ClassFileFormatVersion;
        static readonly RELEASE_17: Internal.ClassFileFormatVersion;
        static readonly RELEASE_4: Internal.ClassFileFormatVersion;
        static readonly RELEASE_16: Internal.ClassFileFormatVersion;
        static readonly RELEASE_1: Internal.ClassFileFormatVersion;
        static readonly RELEASE_11: Internal.ClassFileFormatVersion;
        static readonly RELEASE_2: Internal.ClassFileFormatVersion;
        static readonly RELEASE_10: Internal.ClassFileFormatVersion;
        static readonly RELEASE_21: Internal.ClassFileFormatVersion;
        static readonly RELEASE_13: Internal.ClassFileFormatVersion;
        static readonly RELEASE_0: Internal.ClassFileFormatVersion;
        static readonly RELEASE_12: Internal.ClassFileFormatVersion;
        static readonly RELEASE_20: Internal.ClassFileFormatVersion;
    }
    type ClassFileFormatVersion_ = "release_16" | "release_17" | "release_9" | ClassFileFormatVersion | "release_18" | "release_19" | "release_6" | "release_12" | "release_13" | "release_5" | "release_14" | "release_8" | "release_7" | "release_15" | "release_2" | "release_20" | "release_1" | "release_10" | "release_21" | "release_4" | "release_11" | "release_3" | "release_0";
    class VibrationSystem$Data {
        constructor()
        setCurrentVibration($$0: Internal.VibrationInfo_): void;
        setTravelTimeInTicks($$0: number): void;
        shouldReloadVibrationParticle(): boolean;
        getSelectionStrategy(): Internal.VibrationSelector;
        decrementTravelTime(): void;
        getCurrentVibration(): Internal.VibrationInfo;
        setReloadVibrationParticle($$0: boolean): void;
        getTravelTimeInTicks(): number;
        set currentVibration($$0: Internal.VibrationInfo_)
        set travelTimeInTicks($$0: number)
        get selectionStrategy(): Internal.VibrationSelector
        get currentVibration(): Internal.VibrationInfo
        set reloadVibrationParticle($$0: boolean)
        get travelTimeInTicks(): number
        static readonly NBT_TAG_KEY: "listener";
        static CODEC: Internal.Codec<Internal.VibrationSystem$Data>;
    }
    type VibrationSystem$Data_ = VibrationSystem$Data;
    class ModelManager implements Internal.PreparableReloadListener, Internal.ModelManagerAccessor, Internal.AutoCloseable, Internal.BakedModelManagerAccessor, Internal.FabricBakedModelManager, Internal.IdentifiableResourceReloadListener {
        constructor($$0: Internal.TextureManager_, $$1: Internal.BlockColors_, $$2: number)
        getModel(id: ResourceLocation_): Internal.BakedModel;
        getModels(): Internal.Map<any, any>;
        getBlockModelShaper(): Internal.BlockModelShaper;
        getFabricDependencies(): Internal.Collection<any>;
        getBakedRegistry(): Internal.Map<any, any>;
        getAtlas($$0: ResourceLocation_): Internal.TextureAtlas;
        handler$hie000$star$modelLoad(profiler: Internal.ProfilerFiller_, preparations: Internal.Map_<any, any>, modelLoader: Internal.ModelBakery_, cir: Internal.CallbackInfoReturnable_<any>, multimap: Internal.Multimap_<any, any>, models: Internal.Map_<any, any>): void;
        updateMaxMipLevel($$0: number): void;
        getModel($$0: Internal.ModelResourceLocation_): Internal.BakedModel;
        getMissingModel(): Internal.BakedModel;
        requiresRender($$0: Internal.BlockState_, $$1: Internal.BlockState_): boolean;
        close(): void;
        getName(): string;
        getFabricId(): ResourceLocation;
        reload($$0: Internal.PreparableReloadListener$PreparationBarrier_, $$1: Internal.ResourceManager_, $$2: Internal.ProfilerFiller_, $$3: Internal.ProfilerFiller_, $$4: Internal.Executor_, $$5: Internal.Executor_): Internal.CompletableFuture<void>;
        get models(): Internal.Map<any, any>
        get blockModelShaper(): Internal.BlockModelShaper
        get fabricDependencies(): Internal.Collection<any>
        get bakedRegistry(): Internal.Map<any, any>
        get missingModel(): Internal.BakedModel
        get name(): string
        get fabricId(): ResourceLocation
        bakedRegistry: Internal.Map<ResourceLocation, Internal.BakedModel>;
    }
    type ModelManager_ = ModelManager;
    class ResourceOrTagKeyArgument <T> implements Internal.ArgumentType<Internal.ResourceOrTagKeyArgument$Result<T>> {
        constructor($$0: Internal.ResourceKey_<Internal.Registry<T>>)
        getExamples(): Internal.Collection<string>;
        parse($$0: Internal.StringReader_): Internal.ResourceOrTagKeyArgument$Result<T>;
        static getResourceOrTagKey<T>($$0: Internal.CommandContext_<Internal.CommandSourceStack>, $$1: string, $$2: Internal.ResourceKey_<Internal.Registry<T>>, $$3: Internal.DynamicCommandExceptionType_): Internal.ResourceOrTagKeyArgument$Result<T>;
        listSuggestions<S>($$0: Internal.CommandContext_<S>, $$1: Internal.SuggestionsBuilder_): Internal.CompletableFuture<Internal.Suggestions>;
        static resourceOrTagKey<T>($$0: Internal.ResourceKey_<Internal.Registry<T>>): Internal.ResourceOrTagKeyArgument<T>;
        parse(arg0: Internal.StringReader_): any;
        get examples(): Internal.Collection<string>
    }
    type ResourceOrTagKeyArgument_<T> = ResourceOrTagKeyArgument<T>;
    interface PrestidigitationEffect {
        abstract effectEntity(arg0: Internal.CastingEnvironment_, arg1: Internal.Entity_): void;
        abstract effectBlock(arg0: Internal.CastingEnvironment_, arg1: BlockPos_): void;
    }
    type PrestidigitationEffect_ = PrestidigitationEffect | Special.Prestidigitation;
    class AccessibleRole extends Internal.AccessibleBundle {
        static readonly MENU_BAR: Internal.AccessibleRole;
        static readonly SCROLL_BAR: Internal.AccessibleRole;
        static readonly FOOTER: Internal.AccessibleRole;
        static readonly PAGE_TAB_LIST: Internal.AccessibleRole;
        static readonly GROUP_BOX: Internal.AccessibleRole;
        static readonly ICON: Internal.AccessibleRole;
        static readonly CHECK_BOX: Internal.AccessibleRole;
        static readonly PROGRESS_MONITOR: Internal.AccessibleRole;
        static readonly DIRECTORY_PANE: Internal.AccessibleRole;
        static readonly LAYERED_PANE: Internal.AccessibleRole;
        static readonly PANEL: Internal.AccessibleRole;
        static readonly GLASS_PANE: Internal.AccessibleRole;
        static readonly TABLE: Internal.AccessibleRole;
        static readonly FILE_CHOOSER: Internal.AccessibleRole;
        static readonly HEADER: Internal.AccessibleRole;
        static readonly POPUP_MENU: Internal.AccessibleRole;
        static readonly WINDOW: Internal.AccessibleRole;
        static readonly MENU_ITEM: Internal.AccessibleRole;
        static readonly SWING_COMPONENT: Internal.AccessibleRole;
        static readonly ROOT_PANE: Internal.AccessibleRole;
        static readonly RADIO_BUTTON: Internal.AccessibleRole;
        static readonly CANVAS: Internal.AccessibleRole;
        static readonly TEXT: Internal.AccessibleRole;
        static readonly DATE_EDITOR: Internal.AccessibleRole;
        static readonly SLIDER: Internal.AccessibleRole;
        static readonly SPIN_BOX: Internal.AccessibleRole;
        static readonly TOOL_BAR: Internal.AccessibleRole;
        static readonly TOOL_TIP: Internal.AccessibleRole;
        static readonly FRAME: Internal.AccessibleRole;
        static readonly TOGGLE_BUTTON: Internal.AccessibleRole;
        static readonly PARAGRAPH: Internal.AccessibleRole;
        static readonly HTML_CONTAINER: Internal.AccessibleRole;
        static readonly DESKTOP_PANE: Internal.AccessibleRole;
        static readonly SCROLL_PANE: Internal.AccessibleRole;
        static readonly PROGRESS_BAR: Internal.AccessibleRole;
        static readonly DIALOG: Internal.AccessibleRole;
        static readonly FILLER: Internal.AccessibleRole;
        static readonly UNKNOWN: Internal.AccessibleRole;
        static readonly RULER: Internal.AccessibleRole;
        static readonly LABEL: Internal.AccessibleRole;
        static readonly PUSH_BUTTON: Internal.AccessibleRole;
        static readonly EDITBAR: Internal.AccessibleRole;
        static readonly DESKTOP_ICON: Internal.AccessibleRole;
        static readonly LIST_ITEM: Internal.AccessibleRole;
        static readonly PAGE_TAB: Internal.AccessibleRole;
        static readonly MENU: Internal.AccessibleRole;
        static readonly PASSWORD_TEXT: Internal.AccessibleRole;
        static readonly SPLIT_PANE: Internal.AccessibleRole;
        static readonly VIEWPORT: Internal.AccessibleRole;
        static readonly HYPERLINK: Internal.AccessibleRole;
        static readonly SEPARATOR: Internal.AccessibleRole;
        static readonly TREE: Internal.AccessibleRole;
        static readonly FONT_CHOOSER: Internal.AccessibleRole;
        static readonly COLOR_CHOOSER: Internal.AccessibleRole;
        static readonly STATUS_BAR: Internal.AccessibleRole;
        static readonly ALERT: Internal.AccessibleRole;
        static readonly COLUMN_HEADER: Internal.AccessibleRole;
        static readonly AWT_COMPONENT: Internal.AccessibleRole;
        static readonly LIST: Internal.AccessibleRole;
        static readonly OPTION_PANE: Internal.AccessibleRole;
        static readonly INTERNAL_FRAME: Internal.AccessibleRole;
        static readonly ROW_HEADER: Internal.AccessibleRole;
        static readonly COMBO_BOX: Internal.AccessibleRole;
    }
    type AccessibleRole_ = AccessibleRole;
    class ConjuredDuckyBlock extends Internal.Block implements Internal.EntityBlock {
        constructor(settings: Internal.BlockBehaviour$Properties_)
        newBlockEntity(arg0: BlockPos_, arg1: Internal.BlockState_): Internal.BlockEntity;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        static setColor(pLevel: Internal.LevelAccessor_, pPos: BlockPos_, colorizer: Internal.FrozenPigment_): void;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        createBlockEntity(pos: BlockPos_, state: Internal.BlockState_): Internal.ConjuredDuckyBlockEntity;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly FACING: Internal.DirectionProperty;
        static readonly VISIBLE: Internal.BooleanProperty;
    }
    type ConjuredDuckyBlock_ = ConjuredDuckyBlock;
    interface Flushable {
        abstract flush(): void;
        (): void;
    }
    type Flushable_ = Flushable;
    class ChunkRenderDispatcher$RenderChunk {
        constructor($$0: Internal.ChunkRenderDispatcher_, $$1: number, $$2: number, $$3: number, $$4: number)
        getRelativeOrigin($$0: Internal.Direction_): BlockPos;
        getOrigin(): BlockPos;
        setNotDirty(): void;
        compileSync($$0: Internal.RenderRegionCache_): void;
        resortTransparency($$0: Internal.RenderType_, $$1: Internal.ChunkRenderDispatcher_): boolean;
        setOrigin($$0: number, $$1: number, $$2: number): void;
        getBuffer($$0: Internal.RenderType_): Internal.VertexBuffer;
        isDirty(): boolean;
        getCompiledChunk(): Internal.ChunkRenderDispatcher$CompiledChunk;
        beginLayer($$0: Internal.BufferBuilder_): void;
        getBoundingBox(): Internal.AABB;
        rebuildChunkAsync($$0: Internal.ChunkRenderDispatcher_, $$1: Internal.RenderRegionCache_): void;
        isDirtyFromPlayer(): boolean;
        createCompileTask($$0: Internal.RenderRegionCache_): Internal.ChunkRenderDispatcher$RenderChunk$ChunkCompileTask;
        setDirty($$0: boolean): void;
        hasAllNeighbors(): boolean;
        releaseBuffers(): void;
        get origin(): BlockPos
        get dirty(): boolean
        get compiledChunk(): Internal.ChunkRenderDispatcher$CompiledChunk
        get boundingBox(): Internal.AABB
        get dirtyFromPlayer(): boolean
        set dirty($$0: boolean)
        readonly index: number;
        static readonly SIZE: 16;
        readonly compiled: Internal.AtomicReference<Internal.ChunkRenderDispatcher$CompiledChunk>;
    }
    type ChunkRenderDispatcher$RenderChunk_ = ChunkRenderDispatcher$RenderChunk;
    class DeadCoralTreeFeature extends Internal.CoralTreeFeature {
        constructor($$0: Internal.Codec_<Internal.NoneFeatureConfiguration>)
    }
    type DeadCoralTreeFeature_ = DeadCoralTreeFeature;
    abstract class FileStore {
        abstract name(): string;
        abstract getFileStoreAttributeView<V extends Internal.FileStoreAttributeView>(arg0: V): V;
        abstract type(): string;
        abstract supportsFileAttributeView(arg0: typeof Internal.FileAttributeView): boolean;
        abstract getAttribute(arg0: string): any;
        abstract getUsableSpace(): number;
        abstract getUnallocatedSpace(): number;
        abstract supportsFileAttributeView(arg0: string): boolean;
        abstract isReadOnly(): boolean;
        abstract getTotalSpace(): number;
        getBlockSize(): number;
        get usableSpace(): number
        get unallocatedSpace(): number
        get readOnly(): boolean
        get totalSpace(): number
        get blockSize(): number
    }
    type FileStore_ = FileStore;
    class GraveyardStructure extends Internal.IafJigsawStructure {
        constructor(config: Internal.Structure$StructureSettings_, startPool: Internal.Holder_<Internal.StructureTemplatePool>, startJigsawName: Internal.Optional_<ResourceLocation>, size: number, startHeight: Internal.HeightProvider_, projectStartToHeightmap: Internal.Optional_<Internal.Heightmap$Types>, maxDistanceFromCenter: number)
        static readonly CODEC: Internal.Codec<Internal.GraveyardStructure>;
    }
    type GraveyardStructure_ = GraveyardStructure;
    class LoomMenu extends Internal.AbstractContainerMenu {
        constructor($$0: number, $$1: Internal.Inventory_, $$2: any_)
        constructor($$0: number, $$1: Internal.Inventory_)
        getSelectablePatterns(): Internal.List<Internal.Holder<Internal.BannerPattern>>;
        getSelectedBannerPatternIndex(): number;
        getPatternSlot(): Internal.Slot;
        getDyeSlot(): Internal.Slot;
        getResultSlot(): Internal.Slot;
        registerUpdateListener($$0: Internal.Runnable_): void;
        getBannerSlot(): Internal.Slot;
        get selectablePatterns(): Internal.List<Internal.Holder<Internal.BannerPattern>>
        get selectedBannerPatternIndex(): number
        get patternSlot(): Internal.Slot
        get dyeSlot(): Internal.Slot
        get resultSlot(): Internal.Slot
        get bannerSlot(): Internal.Slot
    }
    type LoomMenu_ = LoomMenu;
    class WalkAnimationState implements Internal.AccessorWalkAnimationState {
        constructor()
        setSpeedOld(arg0: number): void;
        isMoving(): boolean;
        position(): number;
        getSpeedOld(): number;
        setPosition(arg0: number): void;
        speed($$0: number): number;
        update($$0: number, $$1: number): void;
        speed(): number;
        setSpeed($$0: number): void;
        position($$0: number): number;
        set speedOld(arg0: number)
        get moving(): boolean
        get speedOld(): number
        set position(arg0: number)
        set speed($$0: number)
    }
    type WalkAnimationState_ = WalkAnimationState;
    class TieredItem extends Internal.Item {
        constructor($$0: Internal.Tier_, $$1: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        getTier(): Internal.Tier;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        get tier(): Internal.Tier
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        tier: Internal.Tier;
    }
    type TieredItem_ = TieredItem;
    class LevelChunkSection implements Internal.BlockListeningSection, Internal.BlockCountingSection {
        constructor($$0: Internal.Registry_<Internal.Biome>)
        constructor($$0: Internal.PalettedContainer_<Internal.BlockState>, $$1: Internal.PalettedContainerRO_<Internal.Holder<Internal.Biome>>)
        read($$0: Internal.FriendlyByteBuf_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        invalidateSection(): void;
        readBiomes($$0: Internal.FriendlyByteBuf_): void;
        getSerializedSize(): number;
        hasOnlyAir(): boolean;
        mayContainAny(trackedBlockStatePredicate: Internal.TrackedBlockStatePredicate_): boolean;
        addToCallback(blockGroup: Internal.ListeningBlockStatePredicate_, tracker: Internal.SectionedBlockChangeTracker_): void;
        isRandomlyTickingBlocks(): boolean;
        setBlockState($$0: number, $$1: number, $$2: number, $$3: Internal.BlockState_): Internal.BlockState;
        getStates(): Internal.PalettedContainer<Internal.BlockState>;
        getBiomes(): Internal.PalettedContainerRO<Internal.Holder<Internal.Biome>>;
        setBlockState($$0: number, $$1: number, $$2: number, $$3: Internal.BlockState_, $$4: boolean): Internal.BlockState;
        maybeHas($$0: Internal.Predicate_<Internal.BlockState>): boolean;
        isRandomlyTickingFluids(): boolean;
        release(): void;
        acquire(): void;
        recalcBlockCounts(): void;
        fillBiomesFromNoise($$0: Internal.BiomeResolver_, $$1: Internal.Climate$Sampler_, $$2: number, $$3: number, $$4: number): void;
        getBlockState($$0: number, $$1: number, $$2: number): Internal.BlockState;
        getNoiseBiome($$0: number, $$1: number, $$2: number): Internal.Holder<Internal.Biome>;
        isRandomlyTicking(): boolean;
        getFluidState($$0: number, $$1: number, $$2: number): Internal.FluidState;
        removeFromCallback(blockGroup: Internal.ListeningBlockStatePredicate_, tracker: Internal.SectionedBlockChangeTracker_): void;
        get serializedSize(): number
        get randomlyTickingBlocks(): boolean
        get states(): Internal.PalettedContainer<Internal.BlockState>
        get biomes(): Internal.PalettedContainerRO<Internal.Holder<Internal.Biome>>
        get randomlyTickingFluids(): boolean
        get randomlyTicking(): boolean
        static readonly BIOME_CONTAINER_BITS: 2;
        readonly states: Internal.PalettedContainer<Internal.BlockState>;
        static readonly SECTION_WIDTH: 16;
        static readonly SECTION_SIZE: 4096;
        static readonly SECTION_HEIGHT: 16;
    }
    type LevelChunkSection_ = LevelChunkSection;
    interface IEnergySource {
        abstract extractAEPower(arg0: number, arg1: Internal.Actionable_, arg2: Internal.PowerMultiplier_): number;
        (arg0: number, arg1: Internal.Actionable, arg2: Internal.PowerMultiplier): number;
    }
    type IEnergySource_ = IEnergySource;
    interface EntityVisual <T extends Internal.Entity> extends Internal.Visual {
        abstract update(arg0: number): void;
        abstract "delete"(): void;
    }
    type EntityVisual_<T extends Internal.Entity> = EntityVisual<T>;
    interface RangedAttackMob {
        abstract performRangedAttack(arg0: Internal.LivingEntity_, arg1: number): void;
        (arg0: Internal.LivingEntity, arg1: number): void;
    }
    type RangedAttackMob_ = RangedAttackMob;
    class InclusiveRange <T extends Internal.Comparable<T>> extends Internal.Record {
        constructor($$0: T, $$1: T)
        static create<T extends Internal.Comparable<T>>($$0: T, $$1: T): Internal.DataResult<Internal.InclusiveRange<T>>;
        maxInclusive(): T;
        static codec<T extends Internal.Comparable<T>>($$0: Internal.Codec_<T>, $$1: T, $$2: T): Internal.Codec<Internal.InclusiveRange<T>>;
        static codec<T extends Internal.Comparable<T>>($$0: Internal.Codec_<T>): Internal.Codec<Internal.InclusiveRange<T>>;
        isValueInRange($$0: T): boolean;
        contains($$0: Internal.InclusiveRange_<T>): boolean;
        minInclusive(): T;
        static readonly INT: Internal.Codec<Internal.InclusiveRange<number>>;
    }
    type InclusiveRange_<T extends Internal.Comparable<T>> = InclusiveRange<T>;
    class ConnectedProperty extends Internal.Enum<Internal.ConnectedProperty> implements Internal.StringRepresentable {
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        static valueOf(name: string): Internal.ConnectedProperty;
        getSerializedName(): string;
        getName(): string;
        static values(): Internal.ConnectedProperty[];
        get serializedName(): string
        get name(): string
        static readonly BOTTOM: Internal.ConnectedProperty;
        static readonly MIDDLE: Internal.ConnectedProperty;
        static readonly TOP: Internal.ConnectedProperty;
    }
    type ConnectedProperty_ = ConnectedProperty | "middle" | "bottom" | "top";
    class LeavesBlock extends Internal.Block implements Internal.IShearable, Internal.SimpleWaterloggedBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        isShearable(item: Internal.ItemStack_, world: Internal.Level_, pos: BlockPos_): boolean;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        onSheared(player: Internal.Player_, item: Internal.ItemStack_, world: Internal.Level_, pos: BlockPos_, fortune: number): Internal.List<Internal.ItemStack>;
        static getOptionalDistanceAt($$0: Internal.BlockState_): Internal.OptionalInt;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly PERSISTENT: Internal.BooleanProperty;
        static readonly DECAY_DISTANCE: 7;
        static readonly WATERLOGGED: Internal.BooleanProperty;
        static readonly DISTANCE: Internal.IntegerProperty;
    }
    type LeavesBlock_ = LeavesBlock;
    class ClientboundPlayerChatPacket extends Internal.Record implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: Internal.FriendlyByteBuf_)
        constructor($$0: Internal.UUID_, $$1: number, $$2: Internal.MessageSignature_, $$3: Internal.SignedMessageBody$Packed_, $$4: net.minecraft.network.chat.Component_, $$5: Internal.FilterMask_, $$6: Internal.ChatType$BoundNetwork_)
        handle(arg0: Internal.PacketListener_): void;
        unsignedContent(): net.minecraft.network.chat.Component;
        write($$0: Internal.FriendlyByteBuf_): void;
        signature(): Internal.MessageSignature;
        handle($$0: Internal.ClientGamePacketListener_): void;
        index(): number;
        filterMask(): Internal.FilterMask;
        chatType(): Internal.ChatType$BoundNetwork;
        body(): Internal.SignedMessageBody$Packed;
        isSkippable(): boolean;
        sender(): Internal.UUID;
        get skippable(): boolean
    }
    type ClientboundPlayerChatPacket_ = ClientboundPlayerChatPacket;
    class Tilt extends Internal.Enum<Internal.Tilt> implements Internal.StringRepresentable {
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        getSerializedName(): string;
        static valueOf($$0: string): Internal.Tilt;
        static values(): Internal.Tilt[];
        causesVibration(): boolean;
        get serializedName(): string
        static readonly NONE: Internal.Tilt;
        static readonly UNSTABLE: Internal.Tilt;
        static readonly PARTIAL: Internal.Tilt;
        static readonly FULL: Internal.Tilt;
    }
    type Tilt_ = "unstable" | "partial" | "full" | Tilt | "none";
    class FuelTankBlock extends Internal.Block implements com.simibubi.create.content.equipment.wrench.IWrenchable, Internal.CustomSoundTypeBlock, Internal.IBE<Internal.FuelTankBlockEntity> {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.FuelTankBlockEntity>): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.FuelTankBlockEntity>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        static isTank(state: Internal.BlockState_): boolean;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.FuelTankBlockEntity;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        getBlockEntityClass(): typeof Internal.FuelTankBlockEntity;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        getBlockEntityType(): Internal.BlockEntityType<Internal.FuelTankBlockEntity>;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.FuelTankBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        getSoundType(state: Internal.BlockState_, world: Internal.LevelReader_, pos: BlockPos_, entity: Internal.Entity_): SoundType;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        get blockEntityClass(): typeof Internal.FuelTankBlockEntity
        set destroySpeed(v: number)
        get blockEntityType(): Internal.BlockEntityType<Internal.FuelTankBlockEntity>
        static readonly TOP: Internal.BooleanProperty;
        static readonly SHAPE: Internal.EnumProperty<Internal.FuelTankBlock$Shape>;
        static readonly BOTTOM: Internal.BooleanProperty;
        static readonly LIGHT_LEVEL: Internal.IntegerProperty;
        static readonly SILENCED_METAL: SoundType;
    }
    type FuelTankBlock_ = FuelTankBlock;
    abstract class ImmutableCollections$AbstractImmutableCollection <E> extends Internal.AbstractCollection<E> {
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        stream(): Internal.Stream<E>;
        forEach(arg0: Internal.Consumer_<E>): void;
        spliterator(): Internal.Spliterator<E>;
        parallelStream(): Internal.Stream<E>;
    }
    type ImmutableCollections$AbstractImmutableCollection_<E> = ImmutableCollections$AbstractImmutableCollection<E>;
    interface ItemBuilder$NameCallback {
        abstract apply(arg0: Internal.ItemStack_): net.minecraft.network.chat.Component;
        (arg0: Internal.ItemStack): net.minecraft.network.chat.Component_;
    }
    type ItemBuilder$NameCallback_ = ItemBuilder$NameCallback;
    interface Readable {
        abstract read(arg0: Internal.CharBuffer_): number;
        (arg0: Internal.CharBuffer): number;
    }
    type Readable_ = Readable;
    class ServerboundTeleportToEntityPacket implements Internal.Packet<Internal.ServerGamePacketListener> {
        constructor($$0: Internal.UUID_)
        constructor($$0: Internal.FriendlyByteBuf_)
        handle(arg0: Internal.PacketListener_): void;
        getEntity($$0: Internal.ServerLevel_): Internal.Entity;
        write($$0: Internal.FriendlyByteBuf_): void;
        handle($$0: Internal.ServerGamePacketListener_): void;
        isSkippable(): boolean;
        get skippable(): boolean
    }
    type ServerboundTeleportToEntityPacket_ = ServerboundTeleportToEntityPacket;
    class NetherVinesFeature extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor(deserializer: Internal.Codec_<Internal.NoneFeatureConfiguration>)
        static isAir(level: Internal.LevelSimulatedReader_, pos: BlockPos_): boolean;
        setBlock(world: Internal.WorldGenLevel_, pos: BlockPos_, state: Internal.BlockState_): boolean;
    }
    type NetherVinesFeature_ = NetherVinesFeature;
    class PrimaryMatch extends Internal.Enum<Internal.PrimaryMatch> implements Internal.StringRepresentable {
        static values(): Internal.PrimaryMatch[];
        static fromName(name: string): Internal.PrimaryMatch;
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        static valueOf(name: string): Internal.PrimaryMatch;
        getSerializedName(): string;
        next(): this;
        get serializedName(): string
        static readonly MOD: Internal.PrimaryMatch;
        static readonly TAGS: Internal.PrimaryMatch;
        static readonly ITEM: Internal.PrimaryMatch;
    }
    type PrimaryMatch_ = "mod" | "tags" | PrimaryMatch | "item";
    class SmeltingUpgradeItem extends Internal.UpgradeItemBase<Internal.CookingUpgradeWrapper$SmeltingUpgradeWrapper> implements Internal.ICookingUpgradeItem {
        constructor(smeltingUpgradeConfig: Internal.CookingUpgradeConfig_, upgradeTypeLimitConfig: any_)
        getCookingUpgradeConfig(): Internal.CookingUpgradeConfig;
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        checkThisForConflictsWithExistingUpgrades(upgradeStack: Internal.ItemStack_, storageWrapper: Internal.IStorageWrapper_, excludeUpgradeSlot: number): Internal.UpgradeSlotChangeResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        canRemoveUpgradeFrom(storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean, player: Internal.Player_): Internal.UpgradeSlotChangeResult;
        setAttackSpeed(attackSpeed: number): void;
        getCleanedUpgradeStack(upgradeStack: Internal.ItemStack_): Internal.ItemStack;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getType(): Internal.UpgradeType<Internal.CookingUpgradeWrapper$SmeltingUpgradeWrapper>;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        getInventoryColumnsTaken(): number;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        canSwapUpgradeFor(upgradeStackToPut: Internal.ItemStack_, upgradeSlot: number, storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        checkExtraInsertConditions(upgradeStack: Internal.ItemStack_, storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean, upgradeInSlot: Internal.IUpgradeItem_<any>): Internal.UpgradeSlotChangeResult;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        canAddUpgradeTo(storageWrapper: Internal.IStorageWrapper_, upgradeStack: Internal.ItemStack_, firstLevelStorage: boolean, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        emi(amount: number): Internal.EmiStack;
        canRemoveUpgradeFrom(storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        get cookingUpgradeConfig(): Internal.CookingUpgradeConfig
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get type(): Internal.UpgradeType<Internal.CookingUpgradeWrapper$SmeltingUpgradeWrapper>
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        get inventoryColumnsTaken(): number
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        static readonly TYPE: Internal.UpgradeType<Internal.CookingUpgradeWrapper$SmeltingUpgradeWrapper>;
    }
    type SmeltingUpgradeItem_ = SmeltingUpgradeItem;
    class ETFConfig$EmissiveRenderModes extends Internal.Enum<Internal.ETFConfig$EmissiveRenderModes> {
        static valueOf(name: string): Internal.ETFConfig$EmissiveRenderModes;
        static values(): Internal.ETFConfig$EmissiveRenderModes[];
        static readonly DULL: Internal.ETFConfig$EmissiveRenderModes;
        static readonly BRIGHT: Internal.ETFConfig$EmissiveRenderModes;
    }
    type ETFConfig$EmissiveRenderModes_ = "dull" | "bright" | ETFConfig$EmissiveRenderModes;
    class LootrChestBlock extends Internal.ChestBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>(pLevel: Internal.Level_, pState: Internal.BlockState_, pBlockEntityType: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type LootrChestBlock_ = LootrChestBlock;
    class ConcretePowderBlock extends Internal.FallingBlock implements Internal.ConcretePowderBlockAccessor {
        constructor($$0: Internal.Block_, $$1: Internal.BlockBehaviour$Properties_)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        onBrokenAfterFall($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.FallingBlockEntity_): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getFallDamageSource($$0: Internal.Entity_): DamageSource;
        arch$holder(): Internal.Holder<Internal.Block>;
        create$getConcrete(): Internal.BlockState;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type ConcretePowderBlock_ = ConcretePowderBlock;
    class TurtleSide extends Internal.Enum<Internal.TurtleSide> {
        static valueOf(name: string): Internal.TurtleSide;
        static values(): Internal.TurtleSide[];
        static readonly LEFT: Internal.TurtleSide;
        static readonly RIGHT: Internal.TurtleSide;
    }
    type TurtleSide_ = TurtleSide | "right" | "left";
    abstract class Fireball extends Internal.AbstractHurtingProjectile implements Internal.ItemSupplier {
        constructor($$0: Internal.EntityType_<Internal.Fireball>, $$1: Internal.Level_)
        constructor($$0: Internal.EntityType_<Internal.Fireball>, $$1: Internal.LivingEntity_, $$2: number, $$3: number, $$4: number, $$5: Internal.Level_)
        constructor($$0: Internal.EntityType_<Internal.Fireball>, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number, $$6: number, $$7: Internal.Level_)
        setMotionY(y: number): void;
        isPeacefulCreature(): boolean;
        getDistance(pos: BlockPos_): number;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        setRotation(yaw: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        isOnScoreboardTeam(teamId: string): boolean;
        setItem($$0: Internal.ItemStack_): void;
        getType(): string;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        self(): Internal.Entity;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        setPosition(x: number, y: number, z: number): void;
        getPassengers(): Internal.EntityArrayList;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnBlockCacheSet(newState: Internal.BlockState_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        isLiving(): boolean;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        alwaysAccepts(): boolean;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        getDisplayName(): net.minecraft.network.chat.Component;
        setMotionX(x: number): void;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        attack(hp: number): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getTeamId(): string;
        setNbt(nbt: Internal.CompoundTag_): void;
        lithiumSetClimbingMobCachingSectionUpdateBehavior(listening: boolean): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        serializeNBT(): Internal.Tag;
        setDynamicLightEnabled(enabled: boolean): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        tell(message: net.minecraft.network.chat.Component_): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        isFrame(): boolean;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        getProfile(): Internal.GameProfile;
        playSound(id: Internal.SoundEvent_): void;
        lithiumOnBlockCacheDeleted(): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        runCommand(command: string): number;
        getDistance(x: number, y: number, z: number): number;
        set motionY(y: number)
        get peacefulCreature(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        set item($$0: Internal.ItemStack_)
        get type(): string
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get server(): Internal.MinecraftServer
        get displayName(): net.minecraft.network.chat.Component
        set motionX(x: number)
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        get facing(): Internal.Direction
        set dynamicLightEnabled(enabled: boolean)
        get motionX(): number
        get waterCreature(): boolean
        get motionZ(): number
        get item(): Internal.ItemStack
        set x(x: number)
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get frame(): boolean
        get profile(): Internal.GameProfile
    }
    type Fireball_ = Fireball;
    interface URLStreamHandlerFactory {
        abstract createURLStreamHandler(arg0: string): Internal.URLStreamHandler;
        (arg0: string): Internal.URLStreamHandler_;
    }
    type URLStreamHandlerFactory_ = URLStreamHandlerFactory;
    class ValueSettingsBoard extends Internal.Record {
        constructor(title: net.minecraft.network.chat.Component_, maxValue: number, milestoneInterval: number, rows: Internal.List_<net.minecraft.network.chat.Component>, formatter: Internal.ValueSettingsFormatter_)
        maxValue(): number;
        milestoneInterval(): number;
        rows(): Internal.List<net.minecraft.network.chat.Component>;
        formatter(): Internal.ValueSettingsFormatter;
        title(): net.minecraft.network.chat.Component;
    }
    type ValueSettingsBoard_ = ValueSettingsBoard;
    interface AccessorMinecraft {
        abstract bookshelf$getFontManager(): Internal.FontManager;
        (): Internal.FontManager_;
    }
    type AccessorMinecraft_ = AccessorMinecraft;
    interface ItemAttributeType {
        abstract getAllAttributes(arg0: Internal.ItemStack_, arg1: Internal.Level_): Internal.List<Internal.ItemAttribute>;
        abstract createAttribute(): Internal.ItemAttribute;
    }
    type ItemAttributeType_ = Special.ItemAttributeType | ItemAttributeType;
    class EnchantedGoldenAppleItem extends Internal.Item {
        constructor($$0: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type EnchantedGoldenAppleItem_ = EnchantedGoldenAppleItem;
    class HoverEvent {
        constructor($$0: Internal.HoverEvent$Action_<T>, $$1: T)
        static deserialize($$0: Internal.JsonObject_): Internal.HoverEvent;
        getAction(): Internal.HoverEvent$Action<any>;
        serialize(): Internal.JsonObject;
        getValue<T>($$0: Internal.HoverEvent$Action_<T>): T;
        get action(): Internal.HoverEvent$Action<any>
    }
    type HoverEvent_ = HoverEvent;
    class HoneycombItem extends Internal.Item implements Internal.SignApplicator {
        constructor($$0: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        tryApplyToSign($$0: Internal.Level_, $$1: Internal.SignBlockEntity_, $$2: boolean, $$3: Internal.Player_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        canApplyToSign($$0: Internal.SignText_, $$1: Internal.Player_): boolean;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        static getWaxed($$0: Internal.BlockState_): Internal.Optional<Internal.BlockState>;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        static readonly WAX_OFF_BY_BLOCK: Internal.Supplier<Internal.BiMap<Internal.Block, Internal.Block>>;
        static readonly WAXABLES: Internal.Supplier<Internal.BiMap<Internal.Block, Internal.Block>>;
    }
    type HoneycombItem_ = HoneycombItem;
    class SmelteryControllerBlock extends Internal.HeatingControllerBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>(pLevel: Internal.Level_, pState: Internal.BlockState_, type: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type SmelteryControllerBlock_ = SmelteryControllerBlock;
    class AgriBlockCondition extends Internal.Record {
        constructor(block: Internal.ExtraCodecs$TagOrElementLocation_, states: Internal.List_<string>, strength: number)
        constructor(block: Internal.ExtraCodecs$TagOrElementLocation_, states: Internal.Optional_<Internal.List<string>>, strength: number)
        static builder(): Internal.AgriBlockCondition$Builder;
        block(): Internal.ExtraCodecs$TagOrElementLocation;
        strength(): number;
        states(): Internal.List<string>;
        static readonly CODEC: Internal.Codec<Internal.AgriBlockCondition>;
    }
    type AgriBlockCondition_ = AgriBlockCondition;
    interface Annotation {
        abstract hashCode(): number;
        abstract toString(): string;
        abstract annotationType(): typeof Internal.Annotation;
        abstract equals(arg0: any): boolean;
    }
    type Annotation_ = Annotation;
    interface CameraAccessor {
        abstract setDetached(arg0: boolean): void;
        set detached(arg0: boolean)
        (arg0: boolean): void;
    }
    type CameraAccessor_ = CameraAccessor;
    interface IStorageProvider extends Internal.IGridNodeService {
        abstract mountInventories(arg0: Internal.IStorageMounts_): void;
        requestUpdate(managedNode: Internal.IManagedGridNode_): void;
        (arg0: Internal.IStorageMounts): void;
    }
    type IStorageProvider_ = IStorageProvider;
    class FrameFinishEval$TYPE$1 implements Internal.ContinuationFrame$Type<Internal.FrameFinishEval> {
        deserializeFromNBT(tag: Internal.CompoundTag_, world: Internal.ServerLevel_): Internal.FrameFinishEval;
    }
    type FrameFinishEval$TYPE$1_ = FrameFinishEval$TYPE$1;
    interface Multiset <E> extends Internal.Collection<E> {
        abstract remove(arg0: any, arg1: number): number;
        abstract add(arg0: E): boolean;
        abstract setCount(arg0: E, arg1: number): number;
        forEachEntry(arg0: Internal.ObjIntConsumer_<E>): void;
        parallelStream(): Internal.Stream<E>;
        abstract isEmpty(): boolean;
        abstract entrySet(): Internal.Set<Internal.Multiset$Entry<E>>;
        abstract retainAll(arg0: Internal.Collection_<any>): boolean;
        abstract elementSet(): Internal.Set<E>;
        abstract containsAll(arg0: Internal.Collection_<any>): boolean;
        abstract count(arg0: any): number;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        abstract add(arg0: E, arg1: number): number;
        abstract setCount(arg0: E, arg1: number, arg2: number): boolean;
        abstract contains(arg0: any): boolean;
        abstract addAll(arg0: Internal.Collection_<E>): boolean;
        abstract toString(): string;
        forEach(arg0: Internal.Consumer_<E>): void;
        abstract toArray<T>(arg0: T[]): T[];
        abstract remove(arg0: any): boolean;
        abstract toArray(): any[];
        abstract iterator(): Internal.Iterator<E>;
        abstract size(): number;
        abstract hashCode(): number;
        stream(): Internal.Stream<E>;
        abstract removeAll(arg0: Internal.Collection_<any>): boolean;
        abstract clear(): void;
        removeIf(arg0: Internal.Predicate_<E>): boolean;
        spliterator(): Internal.Spliterator<E>;
        abstract equals(arg0: any): boolean;
        get empty(): boolean
    }
    type Multiset_<E> = Multiset<E>;
    class BrainsweepRecipe$Serializer extends Internal.RecipeSerializerBase<Internal.BrainsweepRecipe> {
        constructor()
        static register<S extends Internal.RecipeSerializer<T>, T extends Internal.Recipe<any>>($$0: string, $$1: S): S;
        fromJson(arg0: ResourceLocation_, arg1: Internal.JsonObject_): Internal.Recipe<any>;
        fromNetwork(recipeID: ResourceLocation_, buf: Internal.FriendlyByteBuf_): Internal.BrainsweepRecipe;
        toNetwork(buf: Internal.FriendlyByteBuf_, recipe: Internal.BrainsweepRecipe_): void;
        fromJson(recipeID: ResourceLocation_, json: Internal.JsonObject_): Internal.BrainsweepRecipe;
        fromNetwork(arg0: ResourceLocation_, arg1: Internal.FriendlyByteBuf_): Internal.Recipe<any>;
    }
    type BrainsweepRecipe$Serializer_ = BrainsweepRecipe$Serializer;
    interface MinecraftSessionService {
        abstract getSecurePropertyValue(arg0: com.mojang.authlib.properties.Property_): string;
        abstract fillProfileProperties(arg0: Internal.GameProfile_, arg1: boolean): Internal.GameProfile;
        abstract getTextures(arg0: Internal.GameProfile_, arg1: boolean): Internal.Map<Internal.MinecraftProfileTexture$Type, Internal.MinecraftProfileTexture>;
        abstract joinServer(arg0: Internal.GameProfile_, arg1: string, arg2: string): void;
        abstract hasJoinedServer(arg0: Internal.GameProfile_, arg1: string, arg2: Internal.InetAddress_): Internal.GameProfile;
    }
    type MinecraftSessionService_ = MinecraftSessionService;
    class MilkBucketItem extends Internal.Item implements Internal.DispensibleContainerItem {
        constructor($$0: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        emptyContents(player: Internal.Player_, world: Internal.Level_, pos: BlockPos_, hitResult: Internal.BlockHitResult_): boolean;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        use(world: Internal.Level_, user: Internal.Player_, hand: Internal.InteractionHand_): Internal.InteractionResultHolder<any>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        checkExtraContent($$0: Internal.Player_, $$1: Internal.Level_, $$2: Internal.ItemStack_, $$3: BlockPos_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type MilkBucketItem_ = MilkBucketItem;
    interface Message {
        abstract getString(): string;
        get string(): string
        (): string;
    }
    type Message_ = Message;
    abstract class Graphics2D extends Internal.Graphics {
        abstract drawRenderableImage(arg0: Internal.RenderableImage_, arg1: Internal.AffineTransform_): void;
        abstract scale(arg0: number, arg1: number): void;
        abstract drawString(arg0: Internal.AttributedCharacterIterator_, arg1: number, arg2: number): void;
        abstract getPaint(): Internal.Paint;
        abstract getTransform(): Internal.AffineTransform;
        abstract clip(arg0: Internal.Shape_): void;
        abstract drawImage(arg0: Internal.BufferedImage_, arg1: Internal.BufferedImageOp_, arg2: number, arg3: number): void;
        abstract setPaint(arg0: Internal.Paint_): void;
        abstract hit(arg0: Internal.Rectangle_, arg1: Internal.Shape_, arg2: boolean): boolean;
        abstract getBackground(): Internal.Color;
        abstract translate(arg0: number, arg1: number): void;
        abstract drawString(arg0: string, arg1: number, arg2: number): void;
        abstract draw(arg0: Internal.Shape_): void;
        abstract setRenderingHint(arg0: Internal.RenderingHints$Key_, arg1: any): void;
        abstract getRenderingHint(arg0: Internal.RenderingHints$Key_): any;
        abstract getFontRenderContext(): Internal.FontRenderContext;
        abstract addRenderingHints(arg0: Internal.Map_<any, any>): void;
        abstract shear(arg0: number, arg1: number): void;
        abstract drawImage(arg0: Internal.Image_, arg1: Internal.AffineTransform_, arg2: Internal.ImageObserver_): boolean;
        abstract setTransform(arg0: Internal.AffineTransform_): void;
        abstract rotate(arg0: number, arg1: number, arg2: number): void;
        abstract drawRenderedImage(arg0: Internal.RenderedImage_, arg1: Internal.AffineTransform_): void;
        abstract setComposite(arg0: Internal.Composite_): void;
        abstract transform(arg0: Internal.AffineTransform_): void;
        abstract fill(arg0: Internal.Shape_): void;
        abstract rotate(arg0: number): void;
        abstract setBackground(arg0: Internal.Color_): void;
        abstract setRenderingHints(arg0: Internal.Map_<any, any>): void;
        abstract drawGlyphVector(arg0: Internal.GlyphVector_, arg1: number, arg2: number): void;
        abstract getDeviceConfiguration(): Internal.GraphicsConfiguration;
        abstract setStroke(arg0: Internal.Stroke_): void;
        abstract getComposite(): Internal.Composite;
        abstract getStroke(): Internal.Stroke;
        abstract getRenderingHints(): Internal.RenderingHints;
        get paint(): Internal.Paint
        get transform(): Internal.AffineTransform
        set paint(arg0: Internal.Paint_)
        get background(): Internal.Color
        get fontRenderContext(): Internal.FontRenderContext
        set transform(arg0: Internal.AffineTransform_)
        set composite(arg0: Internal.Composite_)
        set background(arg0: Internal.Color_)
        set renderingHints(arg0: Internal.Map_<any, any>)
        get deviceConfiguration(): Internal.GraphicsConfiguration
        set stroke(arg0: Internal.Stroke_)
        get composite(): Internal.Composite
        get stroke(): Internal.Stroke
        get renderingHints(): Internal.RenderingHints
    }
    type Graphics2D_ = Graphics2D;
    interface EventLoopGroup extends Internal.EventExecutorGroup {
        abstract invokeAll<T>(arg0: Internal.Collection_<Internal.Callable<T>>, arg1: number, arg2: Internal.TimeUnit_): Internal.List<Internal.Future<T>>;
        abstract submit<T>(arg0: Internal.Runnable_, arg1: T): io.netty.util.concurrent.Future<T>;
        abstract scheduleAtFixedRate(arg0: Internal.Runnable_, arg1: number, arg2: number, arg3: Internal.TimeUnit_): io.netty.util.concurrent.ScheduledFuture<any>;
        spliterator(): Internal.Spliterator<Internal.EventExecutor>;
        abstract schedule<V>(arg0: Internal.Callable_<V>, arg1: number, arg2: Internal.TimeUnit_): io.netty.util.concurrent.ScheduledFuture<V>;
        /**
         * @deprecated
        */
        abstract register(arg0: io.netty.channel.Channel_, arg1: Internal.ChannelPromise_): Internal.ChannelFuture;
        abstract isTerminated(): boolean;
        abstract next(): Internal.EventLoop;
        abstract register(arg0: Internal.ChannelPromise_): Internal.ChannelFuture;
        abstract invokeAny<T>(arg0: Internal.Collection_<Internal.Callable<T>>, arg1: number, arg2: Internal.TimeUnit_): T;
        abstract register(arg0: io.netty.channel.Channel_): Internal.ChannelFuture;
        abstract scheduleWithFixedDelay(arg0: Internal.Runnable_, arg1: number, arg2: number, arg3: Internal.TimeUnit_): io.netty.util.concurrent.ScheduledFuture<any>;
        abstract isShutdown(): boolean;
        /**
         * @deprecated
        */
        abstract shutdownNow(): Internal.List<Internal.Runnable>;
        abstract invokeAll<T>(arg0: Internal.Collection_<Internal.Callable<T>>): Internal.List<Internal.Future<T>>;
        abstract shutdownGracefully(arg0: number, arg1: number, arg2: Internal.TimeUnit_): io.netty.util.concurrent.Future<any>;
        abstract shutdownGracefully(): io.netty.util.concurrent.Future<any>;
        /**
         * @deprecated
        */
        abstract shutdown(): void;
        abstract terminationFuture(): io.netty.util.concurrent.Future<any>;
        abstract iterator(): Internal.Iterator<Internal.EventExecutor>;
        abstract awaitTermination(arg0: number, arg1: Internal.TimeUnit_): boolean;
        forEach(arg0: Internal.Consumer_<Internal.EventExecutor>): void;
        abstract schedule(arg0: Internal.Runnable_, arg1: number, arg2: Internal.TimeUnit_): io.netty.util.concurrent.ScheduledFuture<any>;
        close(): void;
        abstract invokeAny<T>(arg0: Internal.Collection_<Internal.Callable<T>>): T;
        abstract execute(arg0: Internal.Runnable_): void;
        abstract submit(arg0: Internal.Runnable_): io.netty.util.concurrent.Future<any>;
        abstract submit<T>(arg0: Internal.Callable_<T>): io.netty.util.concurrent.Future<T>;
        abstract isShuttingDown(): boolean;
        get terminated(): boolean
        get shutdown(): boolean
        get shuttingDown(): boolean
    }
    type EventLoopGroup_ = EventLoopGroup;
    interface ICraftingRequester extends Internal.IActionHost, Internal.IGridNodeService {
        abstract insertCraftedItems(arg0: Internal.ICraftingLink_, arg1: Internal.AEKey_, arg2: number, arg3: Internal.Actionable_): number;
        abstract getActionableNode(): Internal.IGridNode;
        abstract getRequestedJobs(): Internal.ImmutableSet<Internal.ICraftingLink>;
        abstract jobStateChange(arg0: Internal.ICraftingLink_): void;
        get actionableNode(): Internal.IGridNode
        get requestedJobs(): Internal.ImmutableSet<Internal.ICraftingLink>
    }
    type ICraftingRequester_ = ICraftingRequester;
    class FloatArgumentInfo implements Internal.ArgumentTypeInfo<Internal.FloatArgumentType, Internal.FloatArgumentInfo$Template> {
        constructor()
        unpack($$0: Internal.FloatArgumentType_): Internal.FloatArgumentInfo$Template;
        deserializeFromNetwork(arg0: Internal.FriendlyByteBuf_): Internal.ArgumentTypeInfo$Template<any>;
        unpack(arg0: Internal.ArgumentType_<any>): Internal.ArgumentTypeInfo$Template<any>;
        serializeToNetwork($$0: Internal.FloatArgumentInfo$Template_, $$1: Internal.FriendlyByteBuf_): void;
        serializeToNetwork(arg0: Internal.ArgumentTypeInfo$Template_<any>, arg1: Internal.FriendlyByteBuf_): void;
        deserializeFromNetwork($$0: Internal.FriendlyByteBuf_): Internal.FloatArgumentInfo$Template;
        serializeToJson($$0: Internal.FloatArgumentInfo$Template_, $$1: Internal.JsonObject_): void;
        serializeToJson(arg0: Internal.ArgumentTypeInfo$Template_<any>, arg1: Internal.JsonObject_): void;
    }
    type FloatArgumentInfo_ = FloatArgumentInfo;
    class EnergyConfig implements Internal.IEnergyConfig<owmii.powah.block.Tier> {
        constructor(capacities: Internal.TieredEnergyValues_, transfer_rates: Internal.TieredEnergyValues_)
        getTransfer(arg0: Internal.Enum_<any>): number;
        getTransfer(variant: owmii.powah.block.Tier_): number;
        getCapacity(arg0: Internal.Enum_<any>): number;
        getCapacity(variant: owmii.powah.block.Tier_): number;
        transfer_rates: Internal.TieredEnergyValues;
        capacities: Internal.TieredEnergyValues;
    }
    type EnergyConfig_ = EnergyConfig;
    class CopperFluidPipeBlock extends jagm.classicpipes.block.FluidPipeBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        static get($$0: Internal.ItemStack_): Internal.Equipable;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>(level: Internal.Level_, state: Internal.BlockState_, blockEntityType: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getEquipSound(): Internal.SoundEvent;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get equipSound(): Internal.SoundEvent
        get mod(): string
        set destroySpeed(v: number)
        static readonly FACING: Internal.EnumProperty<Internal.FacingOrNone>;
        static readonly ENABLED: Internal.BooleanProperty;
    }
    type CopperFluidPipeBlock_ = CopperFluidPipeBlock;
    class PiglinBruteSpecificSensor extends Internal.Sensor<Internal.LivingEntity> {
        constructor()
    }
    type PiglinBruteSpecificSensor_ = PiglinBruteSpecificSensor;
    class LevelTicks <T> implements Internal.IMixinWorldTickScheduler<any>, Internal.LevelTickAccess<T> {
        constructor($$0: Internal.LongPredicate_, $$1: Internal.Supplier_<Internal.ProfilerFiller>)
        clearArea($$0: Internal.BoundingBox_): void;
        count(): number;
        copyArea($$0: Internal.BoundingBox_, $$1: Vec3i_): void;
        schedule($$0: Internal.ScheduledTick_<T>): void;
        tick($$0: number, $$1: number, $$2: Internal.BiConsumer_<BlockPos, T>): void;
        addContainer($$0: Internal.ChunkPos_, $$1: Internal.LevelChunkTicks_<T>): void;
        litematica_getChunkTickSchedulers(): Internal.Long2ObjectMap<any>;
        willTickThisTick($$0: BlockPos_, $$1: T): boolean;
        hasScheduledTick($$0: BlockPos_, $$1: T): boolean;
        copyAreaFrom($$0: Internal.LevelTicks_<T>, $$1: Internal.BoundingBox_, $$2: Vec3i_): void;
        removeContainer($$0: Internal.ChunkPos_): void;
    }
    type LevelTicks_<T> = LevelTicks<T>;
    interface Rotate <Self extends Internal.Rotate<Self>> {
        rotateTo(fromX: number, fromY: number, fromZ: number, toX: number, toY: number, toZ: number): Self;
        abstract rotate(arg0: Internal.Quaternionfc_): Self;
        rotate(radians: number, axis: Internal.Axis_): Self;
        rotateXDegrees(degrees: number): Self;
        rotateTo(from: Internal.Direction_, to: Internal.Direction_): Self;
        rotateZDegrees(degrees: number): Self;
        rotate(axisAngle: Internal.AxisAngle4f_): Self;
        rotate(radians: number, axisX: number, axisY: number, axisZ: number): Self;
        rotateX(radians: number): Self;
        rotateDegrees(degrees: number, axis: Internal.Direction$Axis_): Self;
        rotateY(radians: number): Self;
        rotateDegrees(degrees: number, axis: Internal.Vector3fc_): Self;
        rotateDegrees(degrees: number, axis: Internal.Direction_): Self;
        rotateDegrees(degrees: number, axis: Internal.Axis_): Self;
        rotateZ(radians: number): Self;
        self(): Self;
        rotateToFace(facing: Internal.Direction_): Self;
        rotate(radians: number, axis: Internal.Direction$Axis_): Self;
        rotateTo(from: Internal.Vector3fc_, to: Internal.Vector3fc_): Self;
        rotateDegrees(degrees: number, axisX: number, axisY: number, axisZ: number): Self;
        rotate(radians: number, axis: Internal.Direction_): Self;
        rotateYDegrees(degrees: number): Self;
        rotate(radians: number, axis: Internal.Vector3fc_): Self;
        (arg0: Internal.Quaternionfc): Self;
    }
    type Rotate_<Self extends Internal.Rotate<Self>> = Rotate<Self>;
    class TransformBlockEffect implements Internal.PrestidigitationEffect {
        constructor(state: Internal.BlockState_)
        effectEntity(env: Internal.CastingEnvironment_, entity: Internal.Entity_): void;
        effectBlock(env: Internal.CastingEnvironment_, position: BlockPos_): void;
        getState(): Internal.BlockState;
        get state(): Internal.BlockState
    }
    type TransformBlockEffect_ = TransformBlockEffect;
    class LaunchPadPartProperty extends Internal.Enum<Internal.LaunchPadPartProperty> implements Internal.StringRepresentable {
        static valueOf(name: string): Internal.LaunchPadPartProperty;
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        isController(): boolean;
        getSerializedName(): string;
        xOffset(): number;
        static values(): Internal.LaunchPadPartProperty[];
        yOffset(): number;
        get controller(): boolean
        get serializedName(): string
        static readonly TOP_LEFT: Internal.LaunchPadPartProperty;
        static readonly BOTTOM: Internal.LaunchPadPartProperty;
        static readonly RIGHT: Internal.LaunchPadPartProperty;
        static readonly BOTTOM_LEFT: Internal.LaunchPadPartProperty;
        static readonly LEFT: Internal.LaunchPadPartProperty;
        static readonly CENTER: Internal.LaunchPadPartProperty;
        static readonly TOP_RIGHT: Internal.LaunchPadPartProperty;
        static readonly BOTTOM_RIGHT: Internal.LaunchPadPartProperty;
        static readonly TOP: Internal.LaunchPadPartProperty;
    }
    type LaunchPadPartProperty_ = "bottom_right" | "top_left" | "top_right" | "center" | LaunchPadPartProperty | "bottom" | "top" | "bottom_left" | "right" | "left";
    interface IComputerAccess {
        abstract getAvailablePeripheral(arg0: string): Internal.IPeripheral;
        abstract queueEvent(arg0: string, ...arg1: any[]): void;
        abstract mountWritable(arg0: string, arg1: Internal.WritableMount_, arg2: string): string;
        abstract getAttachmentName(): string;
        mountWritable(desiredLocation: string, mount: Internal.WritableMount_): string;
        abstract getAvailablePeripherals(): Internal.Map<string, Internal.IPeripheral>;
        abstract mount(arg0: string, arg1: Internal.Mount_, arg2: string): string;
        abstract getMainThreadMonitor(): Internal.WorkMonitor;
        mount(desiredLocation: string, mount: Internal.Mount_): string;
        abstract unmount(arg0: string): void;
        abstract getID(): number;
        get attachmentName(): string
        get availablePeripherals(): Internal.Map<string, Internal.IPeripheral>
        get mainThreadMonitor(): Internal.WorkMonitor
        get ID(): number
    }
    type IComputerAccess_ = IComputerAccess;
    class ConductorWhistleFlagBlockEntity extends Internal.SmartBlockEntity implements Internal.TransformableBlockEntity {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        transform(blockEntity: Internal.BlockEntity_, transform: Internal.StructureTransform_): void;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        get infiniteBoundingBox(): Internal.AABB
        station: Internal.TrackTargetingBehaviour<Internal.GlobalStation>;
    }
    type ConductorWhistleFlagBlockEntity_ = ConductorWhistleFlagBlockEntity;
    interface SpriteTicker extends Internal.AutoCloseable {
        abstract close(): void;
        abstract tickAndUpload(arg0: number, arg1: number): void;
    }
    type SpriteTicker_ = SpriteTicker;
    class ContainerFoodItem$FluidContainerFoodItem extends Internal.ContainerFoodItem {
        constructor(props: Internal.Item$Properties_, fluid: Internal.Supplier_<Internal.FluidStack>)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ContainerFoodItem$FluidContainerFoodItem_ = ContainerFoodItem$FluidContainerFoodItem;
    class OptionInstance <T> implements Internal.OptionInstanceAccessor<any> {
        constructor($$0: string, $$1: Internal.OptionInstance$TooltipSupplier_<T>, $$2: Internal.OptionInstance$CaptionBasedToString_<T>, $$3: Internal.OptionInstance$ValueSet_<T>, $$4: Internal.Codec_<T>, $$5: T, $$6: Internal.Consumer_<T>)
        constructor($$0: string, $$1: Internal.OptionInstance$TooltipSupplier_<T>, $$2: Internal.OptionInstance$CaptionBasedToString_<T>, $$3: Internal.OptionInstance$ValueSet_<T>, $$4: T, $$5: Internal.Consumer_<T>)
        createButton($$0: Internal.Options_, $$1: number, $$2: number, $$3: number, $$4: Internal.Consumer_<T>): Internal.AbstractWidget;
        static cachedConstantTooltip<T>($$0: net.minecraft.network.chat.Component_): Internal.OptionInstance$TooltipSupplier<T>;
        static createBoolean($$0: string, $$1: Internal.OptionInstance$TooltipSupplier_<boolean>, $$2: boolean, $$3: Internal.Consumer_<boolean>): Internal.OptionInstance<boolean>;
        getInitialValue(): any;
        createButton($$0: Internal.Options_, $$1: number, $$2: number, $$3: number): Internal.AbstractWidget;
        values(): Internal.OptionInstance$ValueSet<T>;
        static createBoolean($$0: string, $$1: boolean, $$2: Internal.Consumer_<boolean>): Internal.OptionInstance<boolean>;
        static forOptionEnum<T extends Internal.OptionEnum>(): Internal.OptionInstance$CaptionBasedToString<T>;
        static createBoolean($$0: string, $$1: boolean): Internal.OptionInstance<boolean>;
        static createBoolean($$0: string, $$1: Internal.OptionInstance$TooltipSupplier_<boolean>, $$2: Internal.OptionInstance$CaptionBasedToString_<boolean>, $$3: boolean, $$4: Internal.Consumer_<boolean>): Internal.OptionInstance<boolean>;
        codec(): Internal.Codec<T>;
        static noTooltip<T>(): Internal.OptionInstance$TooltipSupplier<T>;
        get(): T;
        static createBoolean($$0: string, $$1: Internal.OptionInstance$TooltipSupplier_<boolean>, $$2: boolean): Internal.OptionInstance<boolean>;
        set($$0: T): void;
        get initialValue(): any
        static readonly BOOLEAN_VALUES: Internal.OptionInstance$Enum<boolean>;
        static readonly BOOLEAN_TO_STRING: Internal.OptionInstance$CaptionBasedToString<boolean>;
    }
    type OptionInstance_<T> = OptionInstance<T>;
    class PineFoliagePlacer extends Internal.FoliagePlacer {
        constructor($$0: Internal.IntProvider_, $$1: Internal.IntProvider_, $$2: Internal.IntProvider_)
        static readonly CODEC: Internal.Codec<Internal.PineFoliagePlacer>;
    }
    type PineFoliagePlacer_ = PineFoliagePlacer;
    class RotatedPillarBlock extends Internal.Block {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        static rotatePillar($$0: Internal.BlockState_, $$1: Internal.Rotation_): Internal.BlockState;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly AXIS: Internal.EnumProperty<Internal.Direction$Axis>;
    }
    type RotatedPillarBlock_ = RotatedPillarBlock;
    class HippogryphTypes {
        constructor(name: string, developer: boolean, biomePredicate: Internal.Predicate_<Internal.Holder<Internal.Biome>>)
        static getWildTypes(): Internal.HippogryphTypes[];
        static getBiomeType(biome: Internal.Holder_<Internal.Biome>): Internal.HippogryphTypes;
        static values(): Internal.List<Internal.HippogryphTypes>;
        allowSpawn(biome: Internal.Holder_<Internal.Biome>): boolean;
        getName(): string;
        getTexture(blink: boolean): ResourceLocation;
        static getRandomType(): Internal.HippogryphTypes;
        static getByName(name: string): Internal.HippogryphTypes;
        get wildTypes(): Internal.HippogryphTypes[]
        get name(): string
        get randomType(): Internal.HippogryphTypes
        static readonly WHITE: Internal.HippogryphTypes;
        static readonly GRAY: Internal.HippogryphTypes;
        static readonly ALEX: Internal.HippogryphTypes;
        static readonly BLACK: Internal.HippogryphTypes;
        readonly developer: boolean;
        static readonly CHESTNUT: Internal.HippogryphTypes;
        static readonly DARK_BROWN: Internal.HippogryphTypes;
        static readonly DODO: Internal.HippogryphTypes;
        static readonly CREAMY: Internal.HippogryphTypes;
        static readonly BROWN: Internal.HippogryphTypes;
        static readonly RAPTOR: Internal.HippogryphTypes;
    }
    type HippogryphTypes_ = HippogryphTypes;
    class TagNetworkSerialization$NetworkPayload {
        write($$0: Internal.FriendlyByteBuf_): void;
        isEmpty(): boolean;
        static read($$0: Internal.FriendlyByteBuf_): Internal.TagNetworkSerialization$NetworkPayload;
        get empty(): boolean
    }
    type TagNetworkSerialization$NetworkPayload_ = TagNetworkSerialization$NetworkPayload;
    /**
     * @deprecated
     * This class is marked to be removed in future!
    */
    class AccessControlContext {
        constructor(arg0: Internal.AccessControlContext_, arg1: Internal.DomainCombiner_)
        constructor(arg0: Internal.ProtectionDomain_[])
        checkPermission(arg0: Internal.Permission_): void;
        getDomainCombiner(): Internal.DomainCombiner;
        get domainCombiner(): Internal.DomainCombiner
    }
    type AccessControlContext_ = AccessControlContext;
    class FallingBlock extends Internal.Block implements Internal.Fallable {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        getDustColor($$0: Internal.BlockState_, $$1: Internal.BlockGetter_, $$2: BlockPos_): number;
        onLand($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.BlockState_, $$4: Internal.FallingBlockEntity_): void;
        setRequiresTool(v: boolean): void;
        onBrokenAfterFall($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.FallingBlockEntity_): void;
        static isFree($$0: Internal.BlockState_): boolean;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getFallDamageSource($$0: Internal.Entity_): DamageSource;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type FallingBlock_ = FallingBlock;
    class RecursivePoint$RecursivePointType <A> extends com.mojang.datafixers.types.Type<A> {
        constructor(arg0: Internal.RecursiveTypeFamily_, arg1: number, arg2: Internal.Supplier_<com.mojang.datafixers.types.Type<A>>)
        everywhere(arg0: Internal.TypeRewriteRule_, arg1: Internal.PointFreeRule_, arg2: boolean, arg3: boolean): Internal.Optional<Internal.RewriteResult<A, any>>;
        one(arg0: Internal.TypeRewriteRule_): Internal.Optional<Internal.RewriteResult<A, any>>;
        out(): Internal.View<A, A>;
        all(arg0: Internal.TypeRewriteRule_, arg1: boolean, arg2: boolean): Internal.RewriteResult<A, any>;
        point(arg0: Internal.DynamicOps_<any>): Internal.Optional<A>;
        index(): number;
        "in"(): Internal.View<A, A>;
        family(): Internal.RecursiveTypeFamily;
        unfold(): com.mojang.datafixers.types.Type<A>;
        findTypeInChildren<FT, FR>(arg0: com.mojang.datafixers.types.Type_<FT>, arg1: com.mojang.datafixers.types.Type_<FR>, arg2: Internal.Type$TypeMatcher_<FT, FR>, arg3: boolean): Internal.Either<Internal.TypedOptic<A, any, FT, FR>, Internal.Type$FieldNotFoundException>;
    }
    type RecursivePoint$RecursivePointType_<A> = RecursivePoint$RecursivePointType<A>;
    class UpgradeGroup {
        constructor(name: string, translName: string)
        name(): string;
        isSolo(): boolean;
        translName(): string;
        get solo(): boolean
        static readonly NONE: Internal.UpgradeGroup;
    }
    type UpgradeGroup_ = UpgradeGroup;
    interface LootTableAccessor {
        abstract fabric_getFunctions(): Internal.LootItemFunction[];
        abstract fabric_getRandomSequenceId(): ResourceLocation;
        abstract fabric_getPools(): Internal.LootPool[];
    }
    type LootTableAccessor_ = LootTableAccessor;
    class TrackSwitchBlock$SwitchConstraint extends Internal.Enum<Internal.TrackSwitchBlock$SwitchConstraint> {
        canGoRight(): boolean;
        static values(): Internal.TrackSwitchBlock$SwitchConstraint[];
        static valueOf(name: string): Internal.TrackSwitchBlock$SwitchConstraint;
        canGoLeft(): boolean;
        static readonly NONE: Internal.TrackSwitchBlock$SwitchConstraint;
        static readonly TO_LEFT: Internal.TrackSwitchBlock$SwitchConstraint;
        static readonly TO_RIGHT: Internal.TrackSwitchBlock$SwitchConstraint;
    }
    type TrackSwitchBlock$SwitchConstraint_ = TrackSwitchBlock$SwitchConstraint | "to_left" | "to_right" | "none";
    class BlockStateConfiguration implements Internal.FeatureConfiguration {
        constructor($$0: Internal.BlockState_)
        getFeatures(): Internal.Stream<Internal.ConfiguredFeature<any, any>>;
        get features(): Internal.Stream<Internal.ConfiguredFeature<any, any>>
        static readonly CODEC: Internal.Codec<Internal.BlockStateConfiguration>;
        readonly state: Internal.BlockState;
    }
    type BlockStateConfiguration_ = BlockStateConfiguration;
    class RedstoneTorchBlock extends Internal.TorchBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly RESTART_DELAY: 160;
        static readonly MAX_RECENT_TOGGLES: 8;
        static readonly RECENT_TOGGLE_TIMER: 60;
        static readonly LIT: Internal.BooleanProperty;
    }
    type RedstoneTorchBlock_ = RedstoneTorchBlock;
    interface AttributeSet$CharacterAttribute {
    }
    type AttributeSet$CharacterAttribute_ = AttributeSet$CharacterAttribute;
    interface GuiAccessor {
        abstract porting_lib$screenHeight(): number;
        abstract porting_lib$canRenderCrosshairForSpectator(arg0: Internal.HitResult_): boolean;
        abstract porting_lib$screenWidth(): number;
    }
    type GuiAccessor_ = GuiAccessor;
    interface HolderLookup$RegistryLookup <T> extends Internal.HolderOwner<T>, Internal.HolderLookup<T> {
        abstract get(arg0: Internal.TagKey_<T>): Internal.Optional<Internal.HolderSet$Named<T>>;
        filterElements($$0: Internal.Predicate_<T>): Internal.HolderLookup<T>;
        abstract get(arg0: Internal.ResourceKey_<T>): Internal.Optional<Internal.Holder$Reference<T>>;
        abstract listTags(): Internal.Stream<Internal.HolderSet$Named<T>>;
        getOrThrow($$0: Internal.TagKey_<T>): Internal.HolderSet$Named<T>;
        abstract key(): Internal.ResourceKey<Internal.Registry<T>>;
        getOrThrow($$0: Internal.ResourceKey_<T>): Internal.Holder$Reference<T>;
        listElementIds(): Internal.Stream<Internal.ResourceKey<T>>;
        canSerializeIn($$0: Internal.HolderOwner_<T>): boolean;
        listTagIds(): Internal.Stream<Internal.TagKey<T>>;
        abstract listElements(): Internal.Stream<Internal.Holder$Reference<T>>;
        filterFeatures($$0: Internal.FeatureFlagSet_): Internal.HolderLookup<T>;
        abstract registryLifecycle(): Internal.Lifecycle;
    }
    type HolderLookup$RegistryLookup_<T> = HolderLookup$RegistryLookup<T>;
    interface RegistryAccess$AccessibleRegistry <T> {
        abstract getEntry(arg0: ResourceLocation_): Internal.Holder<T>;
        abstract getEntry(arg0: T): Internal.Holder<T>;
    }
    type RegistryAccess$AccessibleRegistry_<T> = RegistryAccess$AccessibleRegistry<T>;
    interface FieldNamingStrategy {
        abstract translateName(arg0: Internal.Field_): string;
        (arg0: Internal.Field): string;
    }
    type FieldNamingStrategy_ = FieldNamingStrategy;
    interface SurfaceRules$RuleSource extends Internal.Function<Internal.SurfaceRules$Context, Internal.SurfaceRules$SurfaceRule> {
        abstract apply(arg0: Internal.SurfaceRules$Context_): Internal.SurfaceRules$SurfaceRule;
        bootstrap($$0: Internal.Registry_<Internal.Codec<Internal.SurfaceRules$RuleSource>>): Internal.Codec<Internal.SurfaceRules$RuleSource>;
        andThen<V>(arg0: Internal.Function_<Internal.SurfaceRules$SurfaceRule, V>): Internal.Function<Internal.SurfaceRules$Context, V>;
        abstract codec(): Internal.KeyDispatchDataCodec<Internal.SurfaceRules$RuleSource>;
        compose<V>(arg0: Internal.Function_<V, Internal.SurfaceRules$Context>): Internal.Function<V, Internal.SurfaceRules$SurfaceRule>;
        identity<T>(): Internal.Function<T, T>;
        readonly CODEC: Internal.Codec<Internal.SurfaceRules$RuleSource>;
    }
    type SurfaceRules$RuleSource_ = SurfaceRules$RuleSource;
    interface CDATASection extends Internal.Text {
        abstract getFirstChild(): org.w3c.dom.Node;
        abstract setData(arg0: string): void;
        abstract cloneNode(arg0: boolean): org.w3c.dom.Node;
        abstract getWholeText(): string;
        abstract getFeature(arg0: string, arg1: string): any;
        abstract isDefaultNamespace(arg0: string): boolean;
        abstract hasAttributes(): boolean;
        abstract isEqualNode(arg0: org.w3c.dom.Node_): boolean;
        abstract getLocalName(): string;
        abstract setPrefix(arg0: string): void;
        abstract getChildNodes(): Internal.NodeList;
        abstract splitText(arg0: number): Internal.Text;
        abstract getData(): string;
        abstract lookupNamespaceURI(arg0: string): string;
        abstract setNodeValue(arg0: string): void;
        abstract setUserData(arg0: string, arg1: any, arg2: Internal.UserDataHandler_): any;
        abstract getBaseURI(): string;
        abstract getLength(): number;
        abstract getUserData(arg0: string): any;
        abstract isElementContentWhitespace(): boolean;
        abstract getParentNode(): org.w3c.dom.Node;
        abstract getPrefix(): string;
        abstract getLastChild(): org.w3c.dom.Node;
        abstract compareDocumentPosition(arg0: org.w3c.dom.Node_): number;
        abstract normalize(): void;
        abstract getOwnerDocument(): Internal.Document;
        abstract hasChildNodes(): boolean;
        abstract substringData(arg0: number, arg1: number): string;
        abstract getNodeName(): string;
        abstract setTextContent(arg0: string): void;
        abstract removeChild(arg0: org.w3c.dom.Node_): org.w3c.dom.Node;
        abstract replaceData(arg0: number, arg1: number, arg2: string): void;
        abstract getNodeValue(): string;
        abstract appendChild(arg0: org.w3c.dom.Node_): org.w3c.dom.Node;
        abstract getNamespaceURI(): string;
        abstract insertData(arg0: number, arg1: string): void;
        abstract insertBefore(arg0: org.w3c.dom.Node_, arg1: org.w3c.dom.Node_): org.w3c.dom.Node;
        abstract replaceWholeText(arg0: string): Internal.Text;
        abstract isSupported(arg0: string, arg1: string): boolean;
        abstract getPreviousSibling(): org.w3c.dom.Node;
        abstract lookupPrefix(arg0: string): string;
        abstract isSameNode(arg0: org.w3c.dom.Node_): boolean;
        abstract getTextContent(): string;
        abstract getAttributes(): Internal.NamedNodeMap;
        abstract getNodeType(): number;
        abstract getNextSibling(): org.w3c.dom.Node;
        abstract appendData(arg0: string): void;
        abstract deleteData(arg0: number, arg1: number): void;
        abstract replaceChild(arg0: org.w3c.dom.Node_, arg1: org.w3c.dom.Node_): org.w3c.dom.Node;
        get firstChild(): org.w3c.dom.Node
        set data(arg0: string)
        get wholeText(): string
        get localName(): string
        set prefix(arg0: string)
        get childNodes(): Internal.NodeList
        get data(): string
        set nodeValue(arg0: string)
        get baseURI(): string
        get length(): number
        get elementContentWhitespace(): boolean
        get parentNode(): org.w3c.dom.Node
        get prefix(): string
        get lastChild(): org.w3c.dom.Node
        get ownerDocument(): Internal.Document
        get nodeName(): string
        set textContent(arg0: string)
        get nodeValue(): string
        get namespaceURI(): string
        get previousSibling(): org.w3c.dom.Node
        get textContent(): string
        get attributes(): Internal.NamedNodeMap
        get nodeType(): number
        get nextSibling(): org.w3c.dom.Node
    }
    type CDATASection_ = CDATASection;
    class HasSturdyFacePredicate implements net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate {
        constructor($$0: Vec3i_, $$1: Internal.Direction_)
        static hasSturdyFace($$0: Internal.Direction_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static noFluid($$0: Vec3i_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        and(arg0: Internal.BiPredicate_<Internal.WorldGenLevel, BlockPos>): Internal.BiPredicate<Internal.WorldGenLevel, BlockPos>;
        static matchesTag($$0: Vec3i_, $$1: Internal.TagKey_<Internal.Block>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static anyOf($$0: Internal.List_<net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static noFluid(): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static anyOf($$0: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_, $$1: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        negate(): Internal.BiPredicate<Internal.WorldGenLevel, BlockPos>;
        test($$0: Internal.WorldGenLevel_, $$1: BlockPos_): boolean;
        static solid($$0: Vec3i_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static insideWorld($$0: Vec3i_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        or(arg0: Internal.BiPredicate_<Internal.WorldGenLevel, BlockPos>): Internal.BiPredicate<Internal.WorldGenLevel, BlockPos>;
        static matchesTag($$0: Internal.TagKey_<Internal.Block>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static solid(): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static alwaysTrue(): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static matchesBlocks($$0: Vec3i_, ...$$1: Internal.Block_[]): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        type(): Internal.BlockPredicateType<any>;
        static matchesBlocks($$0: Vec3i_, $$1: Internal.List_<Internal.Block>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static allOf(...$$0: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_[]): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static replaceable(): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static wouldSurvive($$0: Internal.BlockState_, $$1: Vec3i_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static matchesFluids($$0: Vec3i_, $$1: Internal.List_<Internal.Fluid>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static not($$0: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static matchesFluids($$0: Vec3i_, ...$$1: Internal.Fluid_[]): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static allOf($$0: Internal.List_<net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static allOf($$0: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_, $$1: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static anyOf(...$$0: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_[]): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static replaceable($$0: Vec3i_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static hasSturdyFace($$0: Vec3i_, $$1: Internal.Direction_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        test(arg0: any, arg1: any): boolean;
        static matchesBlocks(...$$0: Internal.Block_[]): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static matchesBlocks($$0: Internal.List_<Internal.Block>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static matchesFluids(...$$0: Internal.Fluid_[]): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static readonly CODEC: Internal.Codec<Internal.HasSturdyFacePredicate>;
    }
    type HasSturdyFacePredicate_ = HasSturdyFacePredicate;
}
declare namespace net.irisshaders.batchedentityrendering.mixin {
    interface RenderStateShardAccessor {
        getGLINT_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard;
        getCRUMBLING_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard;
        getNO_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard;
        get GLINT_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard
        get CRUMBLING_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard
        get NO_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard
    }
    type RenderStateShardAccessor_ = RenderStateShardAccessor;
}
declare namespace org.apache.logging.log4j {
    interface Marker extends Internal.Serializable {
        abstract getParents(): org.apache.logging.log4j.Marker[];
        abstract hasParents(): boolean;
        abstract hashCode(): number;
        abstract addParents(...markers: org.apache.logging.log4j.Marker_[]): this;
        abstract isInstanceOf(name: string): boolean;
        abstract getName(): string;
        abstract isInstanceOf(m: org.apache.logging.log4j.Marker_): boolean;
        abstract setParents(...markers: org.apache.logging.log4j.Marker_[]): this;
        abstract equals(obj: any): boolean;
        abstract remove(marker: org.apache.logging.log4j.Marker_): boolean;
        get parents(): org.apache.logging.log4j.Marker[]
        get name(): string
        set parents(...markers: org.apache.logging.log4j.Marker_[])
    }
    type Marker_ = Marker;
}
declare namespace net.p3pp3rf1y.sophisticatedcore.mixin.client.accessor {
    interface ScreenAccessor {
        abstract getFont(): net.minecraft.client.gui.Font;
        abstract callAddRenderableWidget(arg0: Internal.GuiEventListener_): Internal.GuiEventListener;
        get font(): net.minecraft.client.gui.Font
    }
    type ScreenAccessor_ = ScreenAccessor;
}
